/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS (Twitter:@kugimoto0715)
 *
 *	[ tbs[fBXN Rg[(MB8877A) ]
 *
 *	RHG
 *	  2001.12.03		fBXNC[W̃}Eg̓t@CI[v
 *						܂̏ԂɂȂ悤ɕύX (townsł̂)
 *						V22DD̃fBXNC[W}Egł̂C
 *	  2001.12.09		2DDC[W2D[hœǂނƃgbN␳sȂ
 *						C
 *	  2002.02.09		ZN^̃wb_̂擪̂PoCg(gbNԍ)
 *						gbNf[^ɔfȂC (Y.Sato)
 *	  2002.02.26		D77t@C̃ZN^RECORD TYPEG[CRCG
 *						[ɔȂC (Apollo)
 *	  2002.04.25		TCh̔rbit0̂ݔr悤ɕύX
 *	  2002.05.03		2DD؂芷sɃgbN̍ēǂݍ݂s悤
 *						ɕύX
 *	  2002.05.06		gbNWX^EZN^WX^R}hsɏ
 *						̋C
 *						READ ADDRESSR}hsɓǂݏoIDtB[h̃g
 *						bNԍZN^WX^ɓ悤ɕύX
 *	  2002.05.24		fdc_readsecIDtB[h̃TChƃTChWX^
 *						rȂ悤ɕύX
 *	  2002.11.10		EFCg}EV[NɑΉ
 *	  2002.12.16		WRITE TRACKR}hsFORCE INTERRUPTR}h
 *						sďł؂ꍇɂf[^݂̏s
 *						ɕύX
 *	  2003.02.08		EFCg쎞̃V[NR}hłFDC荞݃^C~
 *						OC
 *	  2003.02.25		EFCgȂ쎞̃V[NnR}hłIRQ OnEFDC
 *						荞݃^C~OC
 *	  2003.03.15		Write TrackDELETED DATA MARKɑΉ
 *						Read TrackŃf[^OSYNC/DATA ADDRESS MARK
 *						YĂ̂C
 *	  2003.04.02		Read Track̏Ԃfdc_readyɔfȂC
 *	  2004.03.17		2DDx^C[WΉ
 *						2D/2DD/VFDt@C̃gbN␳C
 *	  2004.03.23		D77t@C̊gbNŃ~XĂ̂C
 *	  2010.07.08		SEEKR}hs̃gbNWX^ɃZbgl
 *						f[^WX^ɃZbglɕύX (OS-9 L1 V1.2 L1.2)
 *	  2010.07.26		u[gtOp~
 *	  2010.08.07		ꎞCWFNgꂽfBA݂ԂŃJg
 *						hCuȊOɃfBAZbgꂽɈꎞCWFN
 *						gIɉC
 *	  2010.11.21		t@C̐256oCg܂łɊɘa
 *						fBA}Eg̃t@CTCY`FbN
 *	  2012.10.11		JghCuɃ}EgD77t@C̃fB
 *						AύXۂɓgbNobt@Ă
 *						܂C
 *	  2017.11.28		V1/V2ł2DDC[WANZX(gbN̂)ɑΉ
 *	  2018.01.03		^Ť咣܂ɂEÛCRCvZASY
 *						ύX(Thanks for Toshio Fukui)
 *	  2020.12.31		FDX68`ɑΉ
 */

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "xm7.h"
#include "device.h"
#include "fdc.h"
#include "crcgen.h"
#include "mainetc.h"
#if XM7_VER >= 3
#include "dmac.h"
#endif
#include "event.h"

/*
 *	O[o [N
 */
BYTE fdc_command;					/* FDCR}h */
BYTE fdc_status;					/* FDCXe[^X */
BYTE fdc_trkreg;					/* gbNWX^ */
BYTE fdc_secreg;					/* ZN^WX^ */
BYTE fdc_datareg;					/* f[^WX^ */
BYTE fdc_sidereg;					/* TChWX^ */
BYTE fdc_drvreg;					/* _hCu */
#if XM7_VER >= 2
BYTE fdc_dsenable;					/* DSCl[u */
#endif
#if XM7_VER >= 3
BYTE fdc_drvregP;					/* hCu */
#endif
BYTE fdc_motor;						/* [^ */
BYTE fdc_drqirq;					/* DRQIRQ */

BYTE fdc_cmdtype;					/* R}h^Cv */
WORD fdc_totalcnt;					/* g[^JE^ */
BYTE fdc_onetime;					/* 1oCg] */
WORD fdc_nowcnt;					/* JgJE^ */
BYTE fdc_ready[FDC_DRIVES];			/* fB */
BOOL fdc_teject[FDC_DRIVES];		/* ꎞCWFNg */
BOOL fdc_writep[FDC_DRIVES];		/* CgveNg */
BYTE fdc_track[FDC_DRIVES];			/* gbN */

#if XM7_VER >= 3
BYTE fdc_logidrv;					/* _hCuԍ */
BYTE fdc_physdrv[FDC_DRIVES];		/* _/hCȗΉ */
BYTE fdc_2ddmode;					/* 2D[hI */
#endif

char fdc_fname[FDC_DRIVES][256+1];	/* t@C */
char fdc_name[FDC_DRIVES][FDC_MEDIAS][17];
BOOL fdc_fwritep[FDC_DRIVES];		/* CgveNg(t@Cx) */
BYTE fdc_header[FDC_DRIVES][0x2b0];	/* D77t@Cwb_ */
BYTE fdc_medias[FDC_DRIVES];		/* fBA */
BYTE fdc_media[FDC_DRIVES];			/* fBAZNg */
BYTE fdc_access[FDC_DRIVES];		/* ANZXLED */

#ifdef FDDSND
BOOL fdc_waitmode;					/* FDCANZXEFCg */
BOOL fdc_sound;						/* FDDV[NtO */
#endif


/*
 *	X^eBbN [N
 */
static BYTE fdc_buffer[0x2000];					/* f[^obt@ */
static BYTE *fdc_dataptr;						/* f[^|C^ */
static DWORD fdc_seekofs[FDC_DRIVES];			/* V[NItZbg */
static DWORD fdc_secofs[FDC_DRIVES];			/* ZN^ItZbg */
static DWORD fdc_foffset[FDC_DRIVES][FDC_MEDIAS];
static DWORD fdc_trklen[FDC_DRIVES];			/* gbNf[^ */
static BOOL fdc_seekvct;						/* V[N(Trk0:TRUE) */
static BYTE fdc_indexcnt;						/* INDEXz[ JE^ */
#ifdef FDDSND
static BOOL fdc_wait;							/* EFCg[hstO */
static int fdc_seek_track;						/* waitmodepV[NJE^ */
#endif
static int fdi_init;							/* C[W̏tO*/
static int fdi_secs;							/* C[W̃ZN^ */
static int fdi_idpos[96];						/* C[W̃ZN^ʒu */
static int fdi_dtpos[96];						/* C[W̃ZN^ʒu */

/*
 *	Xebv[ge[u
 */
#ifdef FDDSND
static const int fdc_steprate[4] = { 6000, 12000, 20000, 30000 };
#endif


/*
 *	vg^Cv錾
 */
static void FASTCALL fdc_readbuf(int drive);	/* PgbNǂݍ */
static BOOL FASTCALL fdc_lost_event(void);		/* LOST DATACxg */
static BOOL FASTCALL fdd_mot_event(void);		/* [^[Cxg */


/*
 *	FDXT|[g
 */
static fdxtrkstat_t *fdx_trkstat;				/* FDXgbNX^[eX */
static BYTE *fdx_trkbuf;						/* FDXgbNobt@ */

void FASTCALL fdx_bf_setbf(BYTE *dst, int dlen, int offset, BYTE *src, int slen);
int FASTCALL fdx_encode_to_raw(
	int rate, BYTE *enc, int enclen, BYTE *raw, int rawlen);
int FASTCALL fdx_raw_to_encode(
	BYTE *raw, int rawlen, BYTE *enc, int enclen);
int FASTCALL fdx_encode_to_raw_pos(BYTE *raw, int rawlen, int encpos);
int FASTCALL fdx_bf_splitclock(BYTE *buf, int length, int offset,
	BYTE *dbuf, int dlen, BOOL instab);
int FASTCALL fdx_make_track(BYTE *buf, int length, BYTE *dbuf);
fdxtrkstat_t* FASTCALL fdx_analyze_track(
	BYTE *enc, int enclen, BOOL israw, BOOL needdata);
void FASTCALL fdx_release_analyzeobject(fdxtrkstat_t *stat);
int FASTCALL fdx_gen_mfm(BYTE *dst, BYTE *src, int size, BOOL *last);
int FASTCALL fdx_gen_iam(BYTE *buf);
int FASTCALL fdx_gen_idam(BYTE *buf);
int FASTCALL fdx_gen_dam(BYTE *buf, BOOL del);


/*
 *	FDC
 *	
 */
BOOL FASTCALL fdc_init(void)
{
	int i;

	/* tbs[t@C֌WZbg */
	for (i=0; i<FDC_DRIVES; i++) {
		fdc_ready[i] = FDC_TYPE_NOTREADY;
		fdc_teject[i] = FALSE;
		fdc_fwritep[i] = FALSE;
		fdc_medias[i] = 0;
	}

	/* t@CItZbgSăNA */
	memset(fdc_foffset, 0, sizeof(fdc_foffset));

	/* EFCg}[htO */
#ifdef FDDSND
	fdc_waitmode = FALSE;
	fdc_sound = FALSE;
	fdc_wait = FALSE;
#endif

	/* [^[Cxgo^ */
	schedule_handle(EVENT_FDD_MOTOR, fdd_mot_event);

	/* C[W񖢏 */
	fdi_init = FALSE;

	/* FDX񏉊 */
	fdx_trkstat = NULL;
	fdx_trkbuf = (BYTE*)malloc(FDX_RAW_BYTES);
	memset(fdx_trkbuf, 0x00, FDX_RAW_BYTES);

	/* CRCvZe[u쐬 */
	crcgen_init();

	return TRUE;
}

/*
 *	FDC
 *	N[Abv
 */
void FASTCALL fdc_cleanup(void)
{
	int i;

	/* tbs[t@C֌WZbg */
	for (i = 0; i < FDC_DRIVES; i++) {
		fdc_ready[i] = FDC_TYPE_NOTREADY;
	}

	/* FDX */
	if (fdx_trkstat) {
		fdx_release_analyzeobject(fdx_trkstat);
		fdx_trkstat = NULL;
	}
	if (fdx_trkbuf) {
		free(fdx_trkbuf);
		fdx_trkbuf = NULL;
	}
}

/*
 *	FDC
 *	Zbg
 */
void FASTCALL fdc_reset(void)
{
#if XM7_VER >= 3
	int i;
#endif

	/* FDCWX^Zbg */
	fdc_command = 0x03;
	fdc_status = 0;
	fdc_trkreg = 0;
	fdc_secreg = 0x01;
	fdc_datareg = 0;
	fdc_sidereg = 0;
	fdc_drvreg = 0;
#if XM7_VER >= 2
	fdc_dsenable = 0x00;
#endif

#if XM7_VER >= 3
	fdc_drvregP = 0;
#endif
	fdc_motor = 0;

#if XM7_VER >= 3
	fdc_logidrv = 0;
	fdc_2ddmode = FALSE;

	/* _hCuhCuɐݒ */
	for (i=0; i<FDC_DRIVES; i++) {
		fdc_physdrv[i] = (BYTE)i;
	}
#endif

	fdc_cmdtype = 0;
	fdc_seekvct = 0;
	memset(fdc_track, 0, sizeof(fdc_track));
	fdc_dataptr = NULL;
	memset(fdc_access, 0, sizeof(fdc_access));

	/* f[^obt@֓ǂݍ */
	fdc_readbuf(fdc_drvreg);
}

/*-[ t@CǗ ]---------------------------------------------------------*/

/*
 *	Read Trackf[^쐬
 */
static void FASTCALL fdc_make_track(void)
{
	int i;
	int j;
	int gap3;
	int track;
	WORD count;
	WORD secs;
	WORD size;
	BOOL flag;
	BYTE *p;
	BYTE *q;
	BOOL ddm;
	int max_track;
	int length;
	fdxheader_t *fdxh;

	/* AtH[}bg`FbN */
	flag = FALSE;
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_2D ||
		fdc_ready[fdc_drvreg] == FDC_TYPE_2DD ||
		fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
		/* 2D/2DD/VFDt@C̃AtH[}bg`FbN͋ */
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
			max_track = 80;
		}
		else {
			max_track = 40;
		}

		if (fdc_track[fdc_drvreg] >= max_track) {
			/* AtH[}bg */
			flag = TRUE;
		}
#if XM7_VER >= 3
		if (((fdc_ready[fdc_drvreg] != FDC_TYPE_2DD) && fdc_2ddmode) &&
			((fdc_track[fdc_drvreg] % 2) == 1)) {
			/* 2DC[W2DDANZXAgbN̓AtH[}bg */
			flag = TRUE;
		}
#endif
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		/* FDXt@C̃AtH[}bg`FbN͓Ǝ */
		fdxh = (fdxheader_t *)fdc_header[fdc_drvreg];
		max_track = fdxh->cylinders;

		if (fdx_trkstat->num == 0) {
			/* AtH[}bg */
			flag = TRUE;
		}
#if XM7_VER >= 3
		if (((fdxh->type == FDX_TYPE_2D ||
			(fdxh->type == FDX_TYPE_RAW && fdxh->cylinders <= 42)) && fdc_2ddmode) &&
			((fdc_track[fdc_drvreg] % 2) == 1)) {
			/* 2DC[W2DDANZXAgbN̓AtH[}bg */
			flag = TRUE;
		}
#endif
	}
	else {
		if ((fdc_buffer[4] == 0) && (fdc_buffer[5] == 0)) {
			/* AtH[}bg */
			flag = TRUE;
		}
#if XM7_VER >= 3
		if (((fdc_header[fdc_drvreg][0x001b] == 0x00) && fdc_2ddmode) &&
			((fdc_track[fdc_drvreg] % 2) == 1)) {
			/* 2DC[W2DDANZXAgbN̓AtH[}bg */
			flag = TRUE;
		}
#endif
	}

	/* AtH[}bgȂA_f[^쐬 */
	if (flag) {
		p = fdc_buffer;
		for (i=0; i<0x1800; i++) {
			*p++ = (BYTE)rand_xor();
		}

		/* f[^|C^AJE^ݒ */
		fdc_dataptr = fdc_buffer;
		fdc_totalcnt = 0x1800;
		fdc_onetime = 32;
		fdc_nowcnt = 0;
		return;
	}

	/* FDXt@C͓Ǝ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		/* AhX}[NœȂNbN */
		length = fdx_make_track(
			fdx_trkstat->encbuf, fdx_trkstat->enclen, fdc_buffer);

		/* f[^̐ */
		if (length > 0x2000) {
			length = 0x2000;
		}

		/* f[^|C^AJE^ݒ */
		fdc_dataptr = fdc_buffer;
		fdc_totalcnt = length;
		fdc_onetime = 32;
		fdc_nowcnt = 0;
		return;
	}

	/* ZN^ZoAf[^ړ */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
		secs = 16;
		q = &fdc_buffer[0x1000];
		memcpy(q, fdc_buffer, 0x1000);
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			/* fBA^Cv(2D) != hCu[h(2DD) */
			track = (fdc_track[fdc_drvreg] >> 1);
		}
		else {
			/* fBA^Cv == hCu[h ␳Ȃ */
			track = fdc_track[fdc_drvreg];
		}
#else
		track = fdc_track[fdc_drvreg];
#endif
		secs = fdc_header[fdc_drvreg][track * 6 + 5];
		count = fdc_header[fdc_drvreg][track * 6 + 4];
		if (count == 0) {
			count = 128;
		}
		else {
			count *= (WORD)256;
		}
		count *= (WORD)secs;

		/* f[^Rs[ */
		q = &fdc_buffer[0x2000 - count];
		for (j = (count - 1); j >= 0; j--) {
			q[j] = fdc_buffer[j];
		}
	}
	else {
		secs = (WORD)(fdc_buffer[0x0005] * 256);
		secs += (WORD)(fdc_buffer[0x0004]);
		count = 0;
		/* SZN^܂āATCYv */
		for (j=0; j<secs; j++) {
			p = &fdc_buffer[count];
			count += (WORD)((p[0x000f] * 256 + p[0x000e]));
			count += (WORD)0x10;
		}
		/* f[^Rs[ */
		q = &fdc_buffer[0x2000 - count];
		for (j = (count - 1); j >= 0; j--) {
			q[j] = fdc_buffer[j];
		}
	}

	/* GAP3 */
	if (secs <= 5) {
		gap3 = 0x74;
	}
	else {
		if (secs <= 10) {
			gap3 = 0x54;
		}
		else {
			if (secs <= 16) {
				gap3 = 0x33;
			}
			else {
				gap3 = 0x10;
			}
		}
	}

	/* obt@ */
	p = fdc_buffer;
	count = 0;

	/* GAP0 */
	for (i=0; i<80; i++) {
		*p++ = 0x4e;
	}
	count += (WORD)80;

	/* SYNC */
	for (i=0; i<12; i++) {
		*p++ = 0;
	}
	count += (WORD)12;

	/* INDEX MARK */
	*p++ = 0xc2;
	*p++ = 0xc2;
	*p++ = 0xc2;
	*p++ = 0xfc;
	count += (WORD)4;

	/* GAP1 */
	for (i=0; i<50; i++) {
		*p++ = 0x4e;
	}
	count += (WORD)50;

	/* ZN^[v */
	for (j=0; j<secs; j++) {
		/* SYNC */
		for (i=0; i<12; i++) {
			*p++ = 0;
		}
		count += (WORD)12;

		/* ID ADDRESS MARK */
		p[0] = 0xa1;
		p[1] = 0xa1;
		p[2] = 0xa1;
		p[3] = 0xfe;

		/* ID */
		if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
			(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
#if XM7_VER >= 3
			if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) && fdc_2ddmode) {
				/* fBA^Cv(2D) != hCu[h(2DD) */
				p[4] = (BYTE)(fdc_track[fdc_drvreg] >> 1);
			}
			else if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) && !fdc_2ddmode) {
				/* fBA^Cv(2DD) != hCu[h(2D) */
				p[4] = (BYTE)(fdc_track[fdc_drvreg] << 1);
			}
			else {
				/* fBA^Cv == hCu[h ␳Ȃ */
				p[4] = fdc_track[fdc_drvreg];
			}
#else
			if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
				/* fBA^Cv(2DD) != hCu[h(2D) */
				p[4] = (BYTE)(fdc_track[fdc_drvreg] << 1);
			}
			else {
				/* fBA^Cv == hCu[h ␳Ȃ */
				p[4] = fdc_track[fdc_drvreg];
			}
#endif
			p[5] = fdc_sidereg;
			p[6] = (BYTE)(j + 1);
			p[7] = 1;
			size = 0x100;
			ddm = FALSE;
		}
		else if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
#if XM7_VER >= 3
			if (fdc_2ddmode) {
				/* fBA^Cv(2D) != hCu[h(2DD) */
				p[4] = (BYTE)(fdc_track[fdc_drvreg] >> 1);
			}
			else {
				/* fBA^Cv == hCu[h ␳Ȃ */
				p[4] = fdc_track[fdc_drvreg];
			}
#else
			p[4] = fdc_track[fdc_drvreg];
#endif
			p[5] = fdc_sidereg;
			p[6] = (BYTE)(j + 1);
			p[7] = fdc_header[fdc_drvreg][p[4] * 6 + 4];
			if (p[7] == 0) {
				size = 128;
			}
			else {
				size = (WORD)(p[7] * 256);
			}
			ddm = FALSE;
		}
		else {
			memcpy(&p[4], q, 4);
			size = (WORD)(q[0x000f] * 256 + q[0x000e]);
			if (q[0x0007] != 0x00) {
				ddm = TRUE;
			}
			else {
				ddm = FALSE;
			}
			q += 0x0010;
		}
		calc_set_crc(p, 8);
		p += (8 + 2);
		count += (WORD)(8 + 2);

		/* GAP2 */
		for (i=0; i<22; i++) {
			*p++ = 0x4e;
		}
		count += (WORD)22;

		/* SYNC */
		for (i=0; i<12; i++) {
			*p++ = 0;
		}
		count += (WORD)12;

		/* DATA ADDRESS MARK */
		p[0] = 0xa1;
		p[1] = 0xa1;
		p[2] = 0xa1;
		if (ddm) {
			/* DELETED DATA MARK */
			p[3] = 0xf8;
		}
		else {
			/* DATA MARK */
			p[3] = 0xfb;
		}

		/* f[^ */
		memcpy(&p[4], q, size);
		q += size;
		calc_set_crc(p, size + 4);
		p += (size + 4 + 2);
		count += (WORD)(size + 4 + 2);

		/* GAP3 */
		for (i=0; i<gap3; i++) {
			*p++ = 0x4e;
		}
		count += (WORD)gap3;
	}

	/* GAP4 */
	j = (0x1800 - count);
	if (j < 0x1800) {
		for (i=0; i<j; i++) {
			*p++ = 0x4e;
		}
		count += (WORD)j;
	}

	/* f[^|C^AJE^ݒ */
	fdc_dataptr = fdc_buffer;
	fdc_totalcnt = count;
	fdc_onetime = 32;
	fdc_nowcnt = 0;
}

/*
 *	IDtB[hobt@ɍ
 *	JE^Af[^|C^ݒ
 */
static void FASTCALL fdc_makeaddr(int index)
{
	int i;
	BYTE *p;
	WORD offset;
	WORD size;
	DWORD *chrn;

	/* ]̂߂̃e|obt@́Aʏobt@ */
	/* ŌׂĐ݂ */
	p = &fdc_buffer[0x1ff0];

	/* ID ADDRESS MARK */
	p[0] = 0xa1;
	p[1] = 0xa1;
	p[2] = 0xa1;
	p[3] = 0xfe;

	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
#if XM7_VER >= 3
		/* 2D/2DD̏ꍇAC,H,R,N͊m肷 */
		if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) && fdc_2ddmode) {
			/* fBA^Cv(2D) != hCu[h(2DD) */
			p[4] = (BYTE)(fdc_track[fdc_drvreg] >> 1);
		}
		else if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) && !fdc_2ddmode) {
			/* fBA^Cv(2DD) != hCu[h(2D) */
			p[4] = (BYTE)(fdc_track[fdc_drvreg] << 1);
		}
		else {
			/* fBA^Cv == hCu[h ␳Ȃ */
			p[4] = fdc_track[fdc_drvreg];
		}
#else
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
			/* fBA^Cv(2DD) != hCu[h(2D) */
			p[4] = (BYTE)(fdc_track[fdc_drvreg] << 1);
		}
		else {
			/* fBA^Cv == hCu[h ␳Ȃ */
			p[4] = fdc_track[fdc_drvreg];
		}
#endif
		p[5] = fdc_sidereg;
		p[6] = (BYTE)(index + 1);
		p[7] = 1;
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
		/* VFD̏ꍇAC,H,R͊mAN̓wb_擾 */
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			/* fBA^Cv(2D) != hCu[h(2DD) */
			p[4] = (BYTE)(fdc_track[fdc_drvreg] >> 1);
		}
		else {
			/* fBA^Cv == hCu[h ␳Ȃ */
			p[4] = fdc_track[fdc_drvreg];
		}
#else
		p[4] = fdc_track[fdc_drvreg];
#endif
		p[5] = fdc_sidereg;
		p[6] = (BYTE)(index + 1);
		p[7] = fdc_header[fdc_drvreg][p[0] * 6 + 4];
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		/* FDX̏ꍇ̓gbNXe[^XC,H,R,N𓾂 */
		chrn = fdx_trkstat->sector[index].chrn;
		p[4] = (BYTE)chrn[0];
		p[5] = (BYTE)chrn[1];
		p[6] = (BYTE)chrn[2];
		p[7] = (BYTE)chrn[3];
	}
	else {
		/* obt@ړĨZN^܂Ői߂ */
		offset = 0;
		i = 0;
		while (i < index) {
			/* ZN^TCY擾 */
			size = fdc_buffer[offset + 0x000f];
			size *= (WORD)256;
			size |= fdc_buffer[offset + 0x000e];

			/* ̃ZN^֐i߂ */
			offset += size;
			offset += (WORD)0x10;

			i++;
		}

		/* C,H,R,NRs[ */
		memcpy(&p[4], &fdc_buffer[offset], 4);
	}

	/* CRC */
	calc_set_crc(p, 8);

	/* f[^|C^AJE^ݒ */
	fdc_dataptr = &fdc_buffer[0x1ff4];
	fdc_totalcnt = 6;
	fdc_onetime = 32;
	fdc_nowcnt = 0;

	/* ŁAZN^WX^ɃgbNԍݒ */
	fdc_secreg = p[4];
}

/*
 *	CfbNXJE^̃ZN^ֈڂ
 */
static int FASTCALL fdc_next_index(void)
{
	int max_track;
	int track;
	int secs;

	ASSERT(fdc_ready[fdc_drvreg] != FDC_TYPE_NOTREADY);

	/* fBXN^Cv`FbN */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
		/* 2D/2DDȂ16ZN^Œ */
		fdc_indexcnt = (BYTE)((fdc_indexcnt + 1) & 0x0f);
		track = fdc_track[fdc_drvreg];
#if XM7_VER >= 3
		if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) && fdc_2ddmode) {
			/* fBA^Cv(2D) && hCu[h(2DD) */
			track >>= 1;
		}
		else if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) && !fdc_2ddmode) {
			/* fBA^Cv(2DD) && hCu[h(2D) */
			track <<= 1;
		}
#else
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
			/* fBA^Cv(2DD) && hCu[h(2D) */
			track <<= 1;
		}
#endif

#if XM7_VER >= 3
		if (fdc_2ddmode) {
			max_track = 80;
		}
		else {
			max_track = 40;
		}
#else
		max_track = 40;
#endif
		if (track >= max_track) {
			return -1;
		}
		return fdc_indexcnt;
	}

	/* D77/VFD/FDX */
	ASSERT( (fdc_ready[fdc_drvreg] == FDC_TYPE_D77) ||
			(fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) ||
			(fdc_ready[fdc_drvreg] == FDC_TYPE_FDX));

	if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
		track = fdc_track[fdc_drvreg];
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			track >>= 1;
		}
#endif
		secs = fdc_header[fdc_drvreg][track * 6 + 5];
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_D77) {
		secs = fdc_buffer[0x0005];
		secs *= 256;
		secs |= fdc_buffer[0x0004];
	}
	else if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		secs = fdx_trkstat->num;
	}
	if (secs == 0) {
		/* AtH[}bg */
		fdc_indexcnt = (BYTE)((fdc_indexcnt + 1) & 0x0f);
		return -1;
	}
	else {
		fdc_indexcnt++;
		if (fdc_indexcnt >= secs) {
			fdc_indexcnt = 0;
		}
		return fdc_indexcnt;
	}
}

/*
 *	ID}[NT
 */
static BOOL FASTCALL fdc_idmark(WORD *p)
{
	WORD offset;
	BYTE dat;

	/* A1 A1 A1 FEF5 F5 F5 FE */
	offset = *p;

	while (offset < fdc_totalcnt) {
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if (dat == 0xfe) {
			*p = offset;
			return TRUE;
		}
	}

	*p = offset;
	return FALSE;
}

/*
 *	f[^}[NT
 */
static BOOL FASTCALL fdc_datamark(WORD *p, BOOL *deleted_mark)
{
	WORD offset;
	BYTE dat;

	/* data mark : A1 A1 A1 FBF5 F5 F5 FB */
	/* deleted data mark : A1 A1 A1 F8F5 F5 F5 F8 */
	offset = *p;

	while (offset < fdc_totalcnt) {
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if ((dat != 0xa1) && (dat != 0xf5)) {
			continue;
		}
		dat = fdc_buffer[offset++];
		if ((dat == 0xfb) || (dat == 0xf8)) {
			*p = offset;
			if (dat == 0xfb) {
				/* 0xFB : DATA MARK */
				*deleted_mark = FALSE;
			}
			else {
				/* 0xF8 : DELETED DATA MARK */
				*deleted_mark = TRUE;
			}
			return TRUE;
		}
	}

	*p = offset;
	return FALSE;
}

/*
 *	gbNݏI
 */
static BOOL FASTCALL fdc_writetrk(void)
{
	int total;
	int sectors;
	WORD offset;
	WORD seclen;
	WORD writep;
	int i;
	int handle;
	BOOL ddm;
	BYTE *p;
	BYTE data;
	BOOL lastbit;
	WORD crc;
	BYTE crcwrk[2];
	fdxheader_t *fdxh;
	fdxtrack_t *fdxth;

	/*  */
	total = 0;
	sectors = 0;

	/* ZN^ƁAf[^̃g[^TCY𐔂 */
	offset = 0;
	while (offset < fdc_totalcnt) {
		/* ID}[NT */
		if (!fdc_idmark(&offset)) {
			break;
		}
		/* C,H,R,N̎$F7 */
		offset += (WORD)4;
		if (offset >= fdc_totalcnt) {
			return FALSE;
		}
		if (fdc_buffer[offset] != 0xf7) {
			return FALSE;
		}
		offset++;
		/* f[^}[NT */
		if (!fdc_datamark(&offset, &ddm)) {
			return FALSE;
		}
		/* OXvZA$F7T */
		seclen = 0;
		while(offset < fdc_totalcnt) {
			if (fdc_buffer[offset] == 0xf7) {
				break;
			}
			offset++;
			seclen++;
		}
		if (offset >= fdc_totalcnt) {
			return FALSE;
		}
		/* ZN^ok */
		total += seclen;
		sectors++;
		offset++;
	}

	/* 2D/2DDfBȀꍇAtotal=0x1000, sectors=0x10K{ */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
		/* total, sectorš */
		if (total != 0x1000) {
			return FALSE;
		}
		if (sectors != 16) {
			return FALSE;
		}

		/* {C,H,NȂǃ`FbNׂ */
		return TRUE;
	}

	/* VFDfBȀꍇA܂ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
		/* {C,H,NȂǃ`FbNׂ */
		return TRUE;
	}

	/* FDXfBȀꍇA܂ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		/* ޕKvȂꍇ͐I */
		if ((sectors == 0) && (total == 0)) {
			return TRUE;
		}

		/* GR[hf[^𐶐 */
		p = fdx_trkstat->encbuf;
		memset(p, 0x00, FDX_ENC_BYTES - FDX_HDRBYTES);
		crc = 0xffff;
		lastbit = FALSE;
		offset = 0;
		while (offset < fdc_totalcnt) {
			data = fdc_buffer[offset];

			switch (data) {
				case 0xf7:	// CRC1,CRC2
					crcwrk[0] = (BYTE)(crc >> 8);
					crcwrk[1] = (BYTE)crc;
					p += fdx_gen_mfm(p, crcwrk, 2, &lastbit);
					break;
				case 0xf8:	// DDAM(A1x3)
				case 0xfb:	// DAM(A1x3)
				case 0xfe:	// IDAM(A1x3)
					if (offset >= 3 &&
						fdc_buffer[offset - 1] == 0xf5 &&
						fdc_buffer[offset - 2] == 0xf5 &&
						fdc_buffer[offset - 3] == 0xf5) {
						if (data == 0xf8) {
							fdx_gen_dam(p - 3 * 2, TRUE);
							lastbit = FALSE;
						} else if (data == 0xfb) {
							fdx_gen_dam(p - 3 * 2, FALSE);
							lastbit = TRUE;
						} else {
							fdx_gen_idam(p - 3 * 2);
							lastbit = FALSE;
						}
						p += 2;
						crc = 0xffff;
						crc = calc_crc_one(crc, 0xa1);
						crc = calc_crc_one(crc, 0xa1);
						crc = calc_crc_one(crc, 0xa1);
					} else {
						p += fdx_gen_mfm(p, &fdc_buffer[offset], 1, &lastbit);
					}
					break;

				case 0xfc:	// IAM(C1x3)
					if (offset >= 3 &&
						fdc_buffer[offset - 1] == 0xf6 &&
						fdc_buffer[offset - 2] == 0xf6 &&
						fdc_buffer[offset - 3] == 0xf6) {
						fdx_gen_iam(p - 3 * 2);
						lastbit = FALSE;
						p += 2;
					} else {
						p += fdx_gen_mfm(p, &fdc_buffer[offset], 1, &lastbit);
					}
					break;

				default:
					p += fdx_gen_mfm(p, &fdc_buffer[offset], 1, &lastbit);
					break;
			}

			/* CRCXV */
			crc = calc_crc_one(crc, fdc_buffer[offset]);
			offset++;
		}

		/* ZN^擾 */
		fdxh = (fdxheader_t *)fdc_header[fdc_drvreg];

		/* f[^Đݒ */
		fdx_trkstat->enclen = (p - fdx_trkstat->encbuf) * 8;

		/*  */
		handle = file_open(fdc_fname[fdc_drvreg], OPEN_RW);
		if (handle == -1) {
			return FALSE;
		}
		if (!file_seek(handle, fdc_seekofs[fdc_drvreg])) {
			file_close(handle);
			return FALSE;
		}

		fdxth = (fdxtrack_t*)fdx_trkbuf;
		if (fdxh->type != FDX_TYPE_RAW) {
			/* GR[hf[^͂̂܂܏o */
			fdx_bf_setbf(fdxth->data, fdx_trkstat->enclen, 0,
				fdx_trkstat->encbuf, fdx_trkstat->enclen);
		} else {
			/* GR[hf[^RAWf[^ɕϊ */
			fdxth->length = fdx_encode_to_raw(
				fdxh->rate, fdx_trkstat->encbuf, fdx_trkstat->enclen,
				fdxth->data, (FDX_RAW_BYTES - FDX_HDRBYTES) * 8);
		}

		if (!file_write(handle, fdx_trkbuf, fdc_trklen[fdc_drvreg])) {
			file_close(handle);
			return FALSE;
		}

		file_close(handle);

		return TRUE;
	}

	/* ZN^Ƃ0x10ԂA]vɂ */
	if ((DWORD)(total + (sectors * 0x10)) > fdc_trklen[fdc_drvreg]) {
		return FALSE;
	}

	/* ޕKvȂꍇ͐I */
	if ((sectors == 0) && (total == 0)) {
		return TRUE;
	}

	/* ܂邱Ƃ킩̂ŁAf[^쐬 */
	writep = 0;
	offset = 0;
	for (i=0; i<sectors; i++) {
		/* ID}[N */
		fdc_idmark(&offset);

		/* 0x10wb_̍쐬 */
		fdc_buffer[writep++] = fdc_buffer[offset++];
		fdc_buffer[writep++] = fdc_buffer[offset++];
		fdc_buffer[writep++] = fdc_buffer[offset++];
		fdc_buffer[writep++] = fdc_buffer[offset++];
		fdc_buffer[writep++] = (BYTE)(sectors & 0xff);
		fdc_buffer[writep++] = (BYTE)(sectors >> 8);
		fdc_buffer[writep++] = 0x00;
		offset++;

		/* f[^}[N̏ */
		fdc_datamark(&offset, &ddm);
		if (ddm) {
			fdc_buffer[writep++] = 0x10;
		}
		else {
			fdc_buffer[writep++] = 0x00;
		}

		/* U[uGANA */
		/* ZN^OX͌ŏ */
		memset(&fdc_buffer[writep], 0, 8);
		writep += (WORD)8;

		/* OX𐔂Rs[ */
		seclen = 0;
		while (fdc_buffer[offset] != 0xf7) {
			fdc_buffer[writep++] = fdc_buffer[offset++];
			seclen++;
		}
		offset++;

		/* ZN^OXݒ */
		fdc_buffer[writep - seclen - 2] = (BYTE)(seclen & 0xff);
		fdc_buffer[writep - seclen - 1] = (BYTE)(seclen >> 8);
	}

	/* t@CɃf[^ */
	handle = file_open(fdc_fname[fdc_drvreg], OPEN_RW);
	if (handle == -1) {
		return FALSE;
	}
	if (!file_seek(handle, fdc_seekofs[fdc_drvreg])) {
		file_close(handle);
		return FALSE;
	}
	if (!file_write(handle, fdc_buffer, (sectors * 0x10) + total)) {
		file_close(handle);
		return FALSE;
	}
	file_close(handle);

	/* I */
	return TRUE;
}

/*
 *	ZN^ݏI
 */
static BOOL FASTCALL fdc_writesec(void)
{
	DWORD offset;
	int handle;
	fdxheader_t *fdxh;
	fdxtrack_t *fdxth;
	fdxsecstat_t *fdxsect;
	BYTE buf[0x2000];
	BYTE enc[0x2000 * 2];
	int total;
	BOOL lastbit;
	WORD crc;

	/* assert */
	ASSERT(fdc_drvreg < FDC_DRIVES);
	ASSERT(fdc_ready[fdc_drvreg] != FDC_TYPE_NOTREADY);
	ASSERT(fdc_dataptr);
	ASSERT(fdc_totalcnt > 0);

	/* FDXt@C̏ꍇ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		/* ZN^擾 */
		fdxh = (fdxheader_t *)fdc_header[fdc_drvreg];
		offset = fdc_secofs[fdc_drvreg];
		fdxsect = &fdx_trkstat->sector[offset];

		// DAM/DDAM̐
		total = 0;
		buf[total++] = 0xa1;
		buf[total++] = 0xa1;
		buf[total++] = 0xa1;

		if (fdxsect->err & FDX_FDD_DDAM) {
			buf[total++] = 0xf8;
			lastbit = FALSE;
		} else {
			buf[total++] = 0xfb;
			lastbit = TRUE;
		}

		// ZN^f[^+CRC̐
		memcpy(&buf[total], fdc_dataptr, fdc_totalcnt);
		crc = calc_crc(&buf[total - 4], fdc_totalcnt + 4);
		total += fdc_totalcnt;
		buf[total + 0] = (BYTE)(crc >> 8);
		buf[total + 1] = (BYTE)crc;
		total += 2;

		// MFMGR[h
		fdx_gen_dam(enc, fdxsect->err & FDX_FDD_DDAM);
		fdx_gen_mfm(&enc[8], &buf[4], total - 4, &lastbit);

		// gbNf[^XV
		fdx_bf_setbf(fdx_trkstat->encbuf, fdx_trkstat->enclen,
			fdxsect->damoffset, enc, total * 2 * 8);

		/* ItZbgZo */
		offset = fdc_seekofs[fdc_drvreg];

		/*  */
		handle = file_open(fdc_fname[fdc_drvreg], OPEN_RW);
		if (handle == -1) {
			return FALSE;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return FALSE;
		}

		fdxth = (fdxtrack_t*)fdx_trkbuf;
		if (fdxh->type != FDX_TYPE_RAW) {
			/* GR[hf[^͂̂܂܏o */
			fdx_bf_setbf(fdxth->data, fdx_trkstat->enclen, 0,
				fdx_trkstat->encbuf, fdx_trkstat->enclen);
		} else {
			/* GR[hf[^RAWf[^ɕϊ */
			fdxth->length = fdx_encode_to_raw(
				fdxh->rate, fdx_trkstat->encbuf, fdx_trkstat->enclen,
				fdxth->data, (FDX_RAW_BYTES - FDX_HDRBYTES) * 8);
		}

		if (!file_write(handle, fdx_trkbuf, fdc_trklen[fdc_drvreg])) {
			file_close(handle);
			return FALSE;
		}

		file_close(handle);

		/* ͌ʂɏ߂(ėp邽) */
		memcpy(fdxsect->data, fdc_dataptr, fdc_totalcnt);
		fdxsect->size = fdc_totalcnt;
		fdxsect->enclen = fdc_totalcnt * 2 * 8;
		fdx_bf_setbf(fdxsect->encdata, fdxsect->enclen, 0,
			&enc[8], fdxsect->enclen);

		return TRUE;
	}

	/* ItZbgZo */
	offset = fdc_seekofs[fdc_drvreg];
	offset += fdc_secofs[fdc_drvreg];

	/*  */
	handle = file_open(fdc_fname[fdc_drvreg], OPEN_RW);
	if (handle == -1) {
		return FALSE;
	}
	if (!file_seek(handle, offset)) {
		file_close(handle);
		return FALSE;
	}
	if (!file_write(handle, fdc_dataptr, fdc_totalcnt)) {
		file_close(handle);
		return FALSE;
	}
	file_close(handle);

	return TRUE;
}

/*
 *	gbNAZN^ATChƈvZN^
 *	JE^Af[^|C^ݒ
 */
static BYTE FASTCALL fdc_readsec(
	BYTE track, BYTE sector, BYTE side, BOOL sidecmp, int *secidx, int cpos)
{
	int secs;
	int	len;
	int i;
	WORD offset;
	WORD size;
	BYTE stat;
	DWORD vfdoffset;
	int fdctrack;
	int secno;
	fdxheader_t *fdxh;
	fdxsecstat_t *fdxsec;
	float ratio;

	/* assert */
	ASSERT(fdc_drvreg < FDC_DRIVES);
	ASSERT(fdc_ready[fdc_drvreg] != FDC_TYPE_NOTREADY);

	/* wb_̂gbNԍ(rp)ݒ */
	fdctrack = fdc_track[fdc_drvreg];

	/* 2D/2DDt@C̏ꍇ */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
#if XM7_VER >= 3
		if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) && fdc_2ddmode) {
			/* fBA^Cv(2D) != hCu[h(2DD) */
			if ((fdctrack % 2) == 1) {
				/* 2DC[W2DDANZXAgbNANZX̓G[ */
				return FDC_ST_RECNFND;
			}
			fdctrack = (BYTE)(fdctrack >> 1);
		}
		else if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) && !fdc_2ddmode) {
			/* fBA^Cv(2DD) != hCu[h(2D) */
			fdctrack = (BYTE)(fdctrack << 1);
		}
#else
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
			/* fBA^Cv(2DD) != hCu[h(2D) */
			fdctrack = (BYTE)(fdctrack << 1);
		}
#endif
		if (track != fdctrack) {
			return FDC_ST_RECNFND;
		}
		if (side != fdc_sidereg) {
			return FDC_ST_RECNFND;
		}
		if ((sector < 1) || (sector > 16)) {
			return FDC_ST_RECNFND;
		}

		/* f[^|C^ݒ */
		fdc_dataptr = &fdc_buffer[(sector - 1) * 0x0100];
		fdc_secofs[fdc_drvreg] = (sector - 1) * 0x0100;

		/* JE^ݒ */
		fdc_totalcnt = 0x0100;
		fdc_onetime = 32;
		fdc_nowcnt = 0;

		/* ZN^̃CfbNXԂ */
		*secidx = sector - 1;

		return 0;
	}

	/* VFDt@C̏ꍇ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			/* fBA^Cv(2D) != hCu[h(2DD) */
			if ((fdctrack % 2) == 1) {
				/* 2DC[W2DDANZXAgbNANZX̓G[ */
				return FDC_ST_RECNFND;
			}
			fdctrack = (BYTE)(fdctrack >> 1);
		}
#endif
		if (track != fdctrack) {
			return FDC_ST_RECNFND;
		}
		if (side != fdc_sidereg) {
			return FDC_ST_RECNFND;
		}

		/* gbNւ̃ItZbg`FbN */
		vfdoffset  = fdc_header[fdc_drvreg][track * 6 + 3];
		vfdoffset *= (DWORD)256;
		vfdoffset |= fdc_header[fdc_drvreg][track * 6 + 2];
		vfdoffset *= (DWORD)256;
		vfdoffset |= fdc_header[fdc_drvreg][track * 6 + 1];
		vfdoffset *= (DWORD)256;
		vfdoffset |= fdc_header[fdc_drvreg][track * 6 + 0];
		if (vfdoffset == 0) {
			return FDC_ST_RECNFND;
		}

		/* gbÑZN^`FbN */
		len = fdc_header[fdc_drvreg][track * 6 + 4];
		if (len == 0) {
			len = 128;
		}
		else {
			len *= 256;
		}
		size = fdc_header[fdc_drvreg][track * 6 + 5];
		if ((sector < 1) || (sector > size)) {
			return FDC_ST_RECNFND;
		}

		/* f[^|C^ݒ */
		fdc_dataptr = &fdc_buffer[(sector - 1) * len];
		fdc_secofs[fdc_drvreg] = (sector - 1) * len;

		/* JE^ݒ */
		fdc_totalcnt = (WORD)len;
		fdc_onetime = 32;
		fdc_nowcnt = 0;

		/* ZN^̃CfbNXԂ */
		*secidx = sector - 1;

		return 0;
	}

	/* FDXt@C̏ꍇ */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		fdxh = (fdxheader_t *)fdc_header[fdc_drvreg];

		/* P`FbN(gbNPʂłĂȂ) */
		if (!(fdx_trkstat->status & FDX_INF_MFM)) {
			return FDC_ST_RECNFND;
		}

		/* ZN^`FbN */
		secs = fdx_trkstat->num;
		if (secs == 0) {
			return FDC_ST_RECNFND;
		}

#if XM7_VER >= 3
		/* 2DC[W2DDANZXAgbNANZX̓G[ */
		if ((fdxh->type == FDX_TYPE_2D ||
			(fdxh->type == FDX_TYPE_RAW && fdxh->cylinders <= 42)) && fdc_2ddmode) {
			if ((fdctrack % 2) == 1) {
				return FDC_ST_RECNFND;
			}
		}
#endif

#ifdef FDDSND
		if (fdc_wait) {
			/* ɈʒuZN^ */
			for (secno = 0; secno < secs; secno++) {
				if (fdi_idpos[secno] > cpos) {
					break;
				}
			}

			/* ȂȂŏ̃ZN^Ƃ */
			if (secno == secs) {
				secno = 0;
			}
		} else {
			/* TJnʒu͐擪 */
			secno = 0;
		}
#else
		/* TJnʒu͐擪 */
		secno = 0;
#endif

		/* ZN^[v */
		for (i=0; i<secs; i++,secno++) {
			/* Nbv */
			if (secno == secs) {
				secno = 0;
			}

			/* ZN^擾 */
			fdxsec = &fdx_trkstat->sector[secno];

			/* C,H,RvZN^邩 */
			if (fdxsec->chrn[0] != track) {
				continue;
			}
			/* TChbit0ȊO͍lȂ */
			if (sidecmp) {
				if ((fdxsec->chrn[1] & 1) != side) {
					continue;
				}
			}
			if (fdxsec->chrn[2] != sector) {
				continue;
			}

			if (fdxsec->err & FDX_FDD_DATACRC) {
				/* GR[hf[^fR[hĕԂ(sf[^Čt) */
				fdx_bf_splitclock(
					fdxsec->encdata, fdxsec->enclen, 0,
					fdc_buffer, fdxsec->size, TRUE);
			} else {
				/* fR[hς݃f[^Rs[ */
				memcpy(fdc_buffer, fdxsec->data, fdxsec->size);
			}

			/* f[^|C^AJE^ݒ */
			fdc_dataptr = fdc_buffer;
			fdc_secofs[fdc_drvreg] = secno;
			fdc_totalcnt = fdxsec->size;
			fdc_nowcnt = 0;

			/* 1oCg̕W] */
			fdc_onetime = 32;

			/* 1oCg̓]Ԓ */
			if (fdxsec->encratio) {
				ratio = (float)(1000 + fdxsec->encratio);
				ratio /= (float)1000;
				fdc_onetime = (int)((float)fdc_onetime * ratio);
				if (fdc_onetime < 29) {
					fdc_onetime = 29;
				} else if (fdc_onetime > 35) {
					fdc_onetime = 35;
				}
			}

			/* Xe[^Xݒ */
			stat = 0;
			if (fdxsec->err & FDX_FDD_DDAM) {
				stat |= FDC_ST_RECTYPE;
			}
			if (fdxsec->err & FDX_FDD_DATACRC) {
				/* Oɐݒ肵Xe[^XɂȂC (ݼ޼) */
				stat |= FDC_ST_CRCERR;
			}

			/* ZN^̃CfbNXԂ */
			*secidx = secno;

			return stat;
		}

		/* SZN^AȂ */
		return FDC_ST_RECNFND;
	}

	/* D77t@C̏ꍇ */
	secs = fdc_buffer[0x0005];
	secs *= (WORD)256;
	secs |= fdc_buffer[0x0004];
	if (secs == 0) {
		return FDC_ST_RECNFND;
	}

#if XM7_VER >= 3
	/* 2DC[W2DDANZXAgbNANZX̓G[ */
	if ((fdc_header[fdc_drvreg][0x001b] == 0x00) && fdc_2ddmode) {
		if ((fdctrack % 2) == 1) {
			return FDC_ST_RECNFND;
		}
	}
#endif

	offset = 0;
	/* ZN^[v */
	for (i=0; i<secs; i++) {
		/* ̃ZN^̃TCYɎ擾 */
		size = fdc_buffer[offset + 0x000f];
		size *= (WORD)256;
		size |= fdc_buffer[offset + 0x000e];

		/* C,H,RvZN^邩 */
		if (fdc_buffer[offset + 0] != track) {
			offset += size;
			offset += (WORD)0x10;
			continue;
		}
		/* TChbit0ȊO͍lȂ悤ɕύX */
		if (sidecmp) {
			if ((BYTE)(fdc_buffer[offset + 1] & 1) != side) {
				offset += size;
				offset += (WORD)0x10;
				continue;
			}
		}
		if (fdc_buffer[offset + 2] != sector) {
			offset += size;
			offset += (WORD)0x10;
			continue;
		}

		/* P`FbN */
		if (fdc_buffer[offset + 0x0006] != 0) {
			continue;
		}

		/* f[^|C^AJE^ݒ */
		fdc_dataptr = &fdc_buffer[offset + 0x0010];
		fdc_secofs[fdc_drvreg] = offset + 0x0010;
		fdc_totalcnt = size;
		fdc_onetime = 32;
		fdc_nowcnt = 0;

		/* Xe[^Xݒ */
		stat = 0;
		if (fdc_buffer[offset + 0x0007] != 0) {
			stat |= FDC_ST_RECTYPE;
		}
		if (fdc_buffer[offset + 0x0008] == 0xb0) {
			/* Oɐݒ肵Xe[^XɂȂC (ݼ޼) */
			stat |= FDC_ST_CRCERR;
		}

		/* ZN^̃CfbNXԂ */
		*secidx = i;

		return stat;
	}

	/* SZN^AȂ */
	return FDC_ST_RECNFND;
}

/*
 *	gbNǂݍ
 */
static void FASTCALL fdc_readbuf(int drive)
{
	DWORD offset;
	DWORD min_offset;
	DWORD len;
	DWORD secs;
	int trkside;
	int handle;
	int max_track;
	int trk;
	fdxheader_t *fdxh;
	fdxtrack_t *fdxth;

	/* C[W͖ */
	fdi_init = FALSE;

	/* hCu`FbN */
	if ((drive < 0) || (drive >= FDC_DRIVES)) {
		return;
	}

	/* fB`FbN */
	if (fdc_ready[drive] == FDC_TYPE_NOTREADY) {
		return;
	}

	/* CfbNXz[JE^NA */
	fdc_indexcnt = 0;

	/* gbN~Q{TCh */
	trkside = fdc_track[drive] * 2 + fdc_sidereg;

	/*
	 * 2D/2DDt@C
	 */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2D) {
			max_track = 80;

#if XM7_VER >= 3
			/* 2Dt@C2DDǂݏȍꍇ̕␳ */
			if (fdc_2ddmode) {
				trkside = (fdc_track[drive] >> 1) * 2 + fdc_sidereg;
			}
#endif
		}
		else {
			max_track = 160;

#if XM7_VER >= 3
			/* 2DDt@C2Dǂݏȍꍇ̕␳ */
			if (!fdc_2ddmode) {
				trkside = fdc_track[drive] * 4 + fdc_sidereg;
			}
#else
			trkside = fdc_track[drive] * 4 + fdc_sidereg;
#endif
		}

		/* I[o[`FbN */
		if (trkside >= max_track) {
			memset(fdc_buffer, 0, 0x1000);
			return;
		}

		/* ItZbgZo */
		offset = (DWORD)trkside;
		offset *= 0x1000;
		fdc_seekofs[drive] = offset;
		fdc_trklen[drive] = 0x1000;

		/* ǂݍ */
		memset(fdc_buffer, 0, 0x1000);
		handle = file_open(fdc_fname[drive], OPEN_R);
		if (handle == -1) {
			return;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return;
		}
		file_read(handle, fdc_buffer, 0x1000);
		file_close(handle);
		return;
	}

	/*
	 * VFDt@C
	 */
	if (fdc_ready[drive] == FDC_TYPE_VFD) {
#if XM7_VER >= 3
		/* 2DD[h̏ꍇA␳ */
		if (fdc_2ddmode) {
			trkside = (fdc_track[drive] >> 1) * 2 + fdc_sidereg;
		}
#endif

		/* ͈̓`FbN */
		if (trkside >= 80) {
			memset(fdc_buffer, 0, 0x1000);
			return;
		}

		/* ItZbgZo */
		offset  = fdc_header[drive][trkside * 6 + 3];
		offset *= 256;
		offset |= fdc_header[drive][trkside * 6 + 2];
		offset *= 256;
		offset |= fdc_header[drive][trkside * 6 + 1];
		offset *= 256;
		offset |= fdc_header[drive][trkside * 6 + 0];
		fdc_seekofs[drive] = offset;

		len		= fdc_header[drive][trkside * 6 + 4];
		secs	= fdc_header[drive][trkside * 6 + 5];
		if (len == 0) {
			len = 128;
		}
		else {
			len *= 256;
		}
		fdc_trklen[drive] = len * secs;

		/* ǂݍ */
		memset(fdc_buffer, 0, fdc_trklen[drive]);
		handle = file_open(fdc_fname[drive], OPEN_R);
		if (handle == -1) {
			return;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return;
		}
		file_read(handle, fdc_buffer, fdc_trklen[drive]);
		file_close(handle);
		return;
	}

	/*
	 * FDXt@C
	 */
	if (fdc_ready[drive] == FDC_TYPE_FDX) {
		/* FDXł͎gpȂ̂ŃNAĂ */
		memset(fdc_buffer, 0, 0x2000);

		fdxh = (fdxheader_t *)fdc_header[drive];
		max_track = fdxh->cylinders * fdxh->heads;

#if XM7_VER >= 3
		if (fdc_2ddmode) {
			/* 2Dt@C2DDǂ݂ꍇAŕ␳ */
			if (fdxh->type == FDX_TYPE_2D || (fdxh->type == FDX_TYPE_RAW && fdxh->cylinders <= 42)) {
				if ((fdc_track[drive] % 2) == 1) {
					/* gbNANZXAZN^0 */
					fdx_trkstat->num = 0;
					return;
				}
				trkside = (fdc_track[drive] >> 1) * 2 + fdc_sidereg;
			}
		} else {
			/* 2DDt@C2Dǂ݂ꍇAŕ␳ (AV40pOS-9) */
			if (fdxh->type == FDX_TYPE_2DD || (fdxh->type == FDX_TYPE_RAW && fdxh->cylinders > 42)) {
				trkside = fdc_track[drive] * 4 + fdc_sidereg;
			}
		}
#else
		/* 2DDt@C2Dǂ݂ꍇAŕ␳ (AV40pOS-9) */
		if (fdxh->type == FDX_TYPE_2DD || (fdxh->type == FDX_TYPE_RAW && fdxh->cylinders > 42)) {
			trkside = fdc_track[drive] * 4 + fdc_sidereg;
		}
#endif

		/* I[o[`FbN */
		if (trkside >= max_track) {
			/* gbNI[o[AZN^0 */
			fdx_trkstat->num = 0;
			return;
		}

		/* wb_ɏ]AItZbgEOXZo */
		len = fdxh->trackblk;
		offset = len * trkside;
		offset += sizeof(fdxheader_t);
		fdc_seekofs[drive] = offset;
		fdc_trklen[drive] = len;

		/* V[NAǂݍ */
		memset(fdx_trkbuf, 0, FDX_RAW_BYTES);
		handle = file_open(fdc_fname[drive], OPEN_R);
		if (handle == -1) {
			return;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return;
		}
		file_read(handle, fdx_trkbuf, len);
		file_close(handle);

		/* gbN̓[N */
		if (fdx_trkstat) {
			fdx_release_analyzeobject(fdx_trkstat);
			fdx_trkstat = NULL;
		}

		/* gbN */
		fdxth = (fdxtrack_t*)fdx_trkbuf;
		if (fdxh->type != FDX_TYPE_RAW) {
			fdx_trkstat = fdx_analyze_track(
				fdxth->data, fdxth->length, FALSE, TRUE);
		} else {
			fdx_trkstat = fdx_analyze_track(
				fdxth->data, fdxth->length, TRUE, TRUE);
		}

		return;
	}

	/*
	 * D77t@C
	 */
	if (fdc_header[drive][0x001b] == 0x00) {
		max_track = 84;
	}
	else {
		max_track = 164;
	}

	/* ANZXĂŏIgbN̎Zo */
	min_offset = (0x0020 + max_track * 4);
	for (trk = 0; trk < max_track; trk++) {
		if ((DWORD)(0x0020 + trk * 4) >= min_offset) {
			break;
		}

		offset  = fdc_header[drive][0x0020 + trk * 4 + 3];
		offset *= 256;
		offset |= fdc_header[drive][0x0020 + trk * 4 + 2];
		offset *= 256;
		offset |= fdc_header[drive][0x0020 + trk * 4 + 1];
		offset *= 256;
		offset |= fdc_header[drive][0x0020 + trk * 4 + 0];
		if ((offset < min_offset) && (offset >= 0x20)) {
			min_offset = offset;
		}
	}
	max_track = (min_offset - 0x20) / 4;

#if XM7_VER >= 3
	if (fdc_2ddmode) {
		/* 2Dt@C2DDǂ݂ꍇAŕ␳ */
		if (fdc_header[drive][0x001b] == 0x00) {
			if ((fdc_track[drive] % 2) == 1) {
				/* gbNANZXAZN^0 */
				fdc_buffer[4] = 0;
				fdc_buffer[5] = 0;
				return;
			}
			trkside = (fdc_track[drive] >> 1) * 2 + fdc_sidereg;
		}
	}
	else {
		/* 2DDt@C2Dǂ݂ꍇAŕ␳ (AV40pOS-9) */
		if (fdc_header[drive][0x001b] == 0x10) {
			trkside = fdc_track[drive] * 4 + fdc_sidereg;
		}
	}
#else
	/* 2DDt@C2Dǂ݂ꍇAŕ␳ (AV40pOS-9) */
	if (fdc_header[drive][0x001b] == 0x10) {
		trkside = fdc_track[drive] * 4 + fdc_sidereg;
	}
#endif

	/* I[o[`FbN */
	if (trkside >= max_track) {
		/* gbNI[o[AZN^0 */
		fdc_buffer[4] = 0;
		fdc_buffer[5] = 0;
		return;
	}

	/* wb_ɏ]AItZbgEOXZo */
	offset = *(DWORD *)(&fdc_header[drive][0x0020 + trkside * 4]);
	if (offset == 0) {
		/* ݂ȂgbN */
		fdc_buffer[4] = 0;
		fdc_buffer[5] = 0;
		return;
	}

	len = *(DWORD *)(&fdc_header[drive][0x0020 + (trkside + 1) * 4]);
	if ((len == 0) || ((trkside + 1) >= max_track)) {
		/* ŏIgbN */
		len = *(DWORD *)(&fdc_header[drive][0x0014]);
	}
	len -= offset;
	if (len > 0x2000) {
		len = 0x2000;
	}
	fdc_seekofs[drive] = offset;
	fdc_trklen[drive] = len;

	/* V[NAǂݍ */
	memset(fdc_buffer, 0, 0x2000);
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return;
	}
	if (!file_seek(handle, offset)) {
		file_close(handle);
		return;
	}
	file_read(handle, fdc_buffer, len);
	file_close(handle);
}

/*
 *	D77t@C wb_ǂݍ
 */
static BOOL FASTCALL fdc_readhead(int drive, int index)
{
	int i;
	DWORD offset;
	DWORD temp;
	int handle;

	/* assert */
	ASSERT((drive >= 0) && (drive < FDC_DRIVES));
	ASSERT((index >= 0) && (index < FDC_MEDIAS));
	ASSERT(fdc_ready[drive] == FDC_TYPE_D77);

	/* ItZbg */
	offset = fdc_foffset[drive][index];

	/* V[NAǂݍ */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return FALSE;
	}
	if (!file_seek(handle, offset)) {
		file_close(handle);
		return FALSE;
	}
	if (!file_read(handle, fdc_header[drive], 0x2b0)) {
		file_close(handle);
		return FALSE;
	}
	file_close(handle);

	/* ^Cv`FbNACgveNgݒ */
	if ((fdc_header[drive][0x001b] != 0x00) &&
		(fdc_header[drive][0x001b] != 0x10)) {
		/* 2D/2DDłȂ */
		return FALSE;
	}
	if (fdc_fwritep[drive]) {
		fdc_writep[drive] = TRUE;
	}
	else {
		if (fdc_header[drive][0x001a] & 0x10) {
			fdc_writep[drive] = TRUE;
		}
		else {
			fdc_writep[drive] = FALSE;
		}
	}

	/* gbNItZbgݒ */
	for (i=0; i<164; i++) {
		temp = 0;
		temp |= fdc_header[drive][0x0020 + i * 4 + 3];
		temp *= 256;
		temp |= fdc_header[drive][0x0020 + i * 4 + 2];
		temp *= 256;
		temp |= fdc_header[drive][0x0020 + i * 4 + 1];
		temp *= 256;
		temp |= fdc_header[drive][0x0020 + i * 4 + 0];

		if (temp != 0) {
			/* f[^ */
			temp += offset;
			*(DWORD *)(&fdc_header[drive][0x0020 + i * 4]) = temp;
		}
	}

	/* fBXNTCY{ItZbg */
	temp = 0;
	temp |= fdc_header[drive][0x001c + 3];
	temp *= 256;
	temp |= fdc_header[drive][0x001c + 2];
	temp *= 256;
	temp |= fdc_header[drive][0x001c + 1];
	temp *= 256;
	temp |= fdc_header[drive][0x001c + 0];
	temp += offset;
	*(DWORD *)(&fdc_header[drive][0x0014]) = temp;

	return TRUE;
}

/*
 *	VFDt@C wb_ǂݍ
 */
static BOOL FASTCALL fdc_readhead_vfd(int drive)
{
	int handle;

	/* assert */
	ASSERT((drive >= 0) && (drive < FDC_DRIVES));
	ASSERT(fdc_ready[drive] == FDC_TYPE_VFD);

	/* V[NAǂݍ */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return FALSE;
	}
	if (!file_seek(handle, 0)) {
		file_close(handle);
		return FALSE;
	}
	if (!file_read(handle, fdc_header[drive], 0x1e0)) {
		file_close(handle);
		return FALSE;
	}
	file_close(handle);

	return TRUE;
}

/*
 *	FDXt@C wb_ǂݍ
 */
static BOOL FASTCALL fdc_readhead_fdx(int drive)
{
	int handle;

	/* assert */
	ASSERT((drive >= 0) && (drive < FDC_DRIVES));
	ASSERT(fdc_ready[drive] == FDC_TYPE_FDX);

	/* V[NAǂݍ */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return FALSE;
	}
	if (!file_seek(handle, 0)) {
		file_close(handle);
		return FALSE;
	}
	if (!file_read(handle, fdc_header[drive], sizeof(fdxheader_t))) {
		file_close(handle);
		return FALSE;
	}
	file_close(handle);

	/* CgveNg */
	if (fdc_fwritep[drive]) {
		fdc_writep[drive] = TRUE;
	}
	else {
		if (((fdxheader_t *)fdc_header[drive])->writeprotect) {
			fdc_writep[drive] = TRUE;
		}
		else {
			fdc_writep[drive] = FALSE;
		}
	}

	return TRUE;
}

/*
 *	݂̃fBÃCgveNg؂ւ
 */
BOOL FASTCALL fdc_setwritep(int drive, BOOL writep)
{
	BYTE header[0x2b0];
	DWORD offset;
	int handle;

	/* assert */
	ASSERT((drive >= 0) && (drive < FDC_DRIVES));
	ASSERT((writep == TRUE) || (writep == FALSE));

	/* fBłȂ΂ȂȂ */
	if (fdc_ready[drive] == FDC_TYPE_NOTREADY) {
		return FALSE;
	}

	/* t@CݕsȂ_ */
	if (fdc_fwritep[drive]) {
		return FALSE;
	}

	/* ǂݍ݁AݒA */
	if (fdc_ready[drive] == FDC_TYPE_FDX) {
		offset = 0;
		handle = file_open(fdc_fname[drive], OPEN_RW);
		if (handle == -1) {
			return FALSE;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return FALSE;
		}
		if (!file_read(handle, header, sizeof(fdxheader_t))) {
			file_close(handle);
			return FALSE;
		}
		if (writep) {
			((fdxheader_t *)header)->writeprotect = 1;
		}
		else {
			((fdxheader_t *)header)->writeprotect = 0;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return FALSE;
		}
		if (!file_write(handle, header, sizeof(fdxheader_t))) {
			file_close(handle);
			return FALSE;
		}
	}

	if (fdc_ready[drive] == FDC_TYPE_D77) {
		offset = fdc_foffset[drive][fdc_media[drive]];
		handle = file_open(fdc_fname[drive], OPEN_RW);
		if (handle == -1) {
			return FALSE;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return FALSE;
		}
		if (!file_read(handle, header, 0x2b0)) {
			file_close(handle);
			return FALSE;
		}
		if (writep) {
			header[0x1a] |= 0x10;
		}
		else {
			header[0x1a] &= ~0x10;
		}
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return FALSE;
		}
		if (!file_write(handle, header, 0x2b0)) {
			file_close(handle);
			return FALSE;
		}
	}

	/*  */
	file_close(handle);
	fdc_writep[drive] = writep;
	return TRUE;
}

/*
 *	fBAԍݒ
 */
BOOL FASTCALL fdc_setmedia(int drive, int index)
{
	/* assert */
	ASSERT((drive >= 0) && (drive < FDC_DRIVES));
	ASSERT((index >= 0) && (index < FDC_MEDIAS));

	/* fBԂ */
	if (fdc_ready[drive] == FDC_TYPE_NOTREADY) {
		return FALSE;
	}

	/* 2D/2DDt@C̏ꍇAindex = 0 */
	if (((fdc_ready[drive] == FDC_TYPE_2D) ||
		 (fdc_ready[drive] == FDC_TYPE_2DD)) && (index != 0)) {
		return FALSE;
	}

	/* VFDt@C̏ꍇAindex = 0`FbNăwb_ǂݍ */
	if (fdc_ready[drive] == FDC_TYPE_VFD) {
		if (index != 0) {
			return FALSE;
		}
		if (!fdc_readhead_vfd(drive)) {
			return FALSE;
		}
	}

	/* FDXt@C̏ꍇAindex = 0`FbNăwb_ǂݍ */
	if (fdc_ready[drive] == FDC_TYPE_FDX) {
		if (index != 0) {
			return FALSE;
		}
		/* CgveNg͓Őݒ */
		if (!fdc_readhead_fdx(drive)) {
			return FALSE;
		}
	}

	/* index > 0 ȂAfdc_foffset𒲂ׂ>0Kv */
	if (index > 0) {
		if (fdc_foffset[drive][index] == 0) {
			return FALSE;
		}
	}

	/* D77t@C̏ꍇAwb_ǂݍ */
	if (fdc_ready[drive] == FDC_TYPE_D77) {
		/* CgveNg͓Őݒ */
		if (!fdc_readhead(drive, index)) {
			return FALSE;
		}
	}
	else if (fdc_ready[drive] != FDC_TYPE_FDX) {
		/* 2D/2DD/VFDt@CȂAt@Cɏ] */
		fdc_writep[drive] = fdc_fwritep[drive];
	}

	/* fBAꂽꍇAꎞCWFNg */
	if (fdc_media[drive] != index) {
		fdc_teject[drive] = FALSE;
	}

	/* f[^obt@ǂݍ݁A[NZ[u */
	fdc_media[drive] = (BYTE)index;
	if (drive == fdc_drvreg) {
		/* JghCuƈvꍇ̂݃obt@ǂݍ݂s */
		fdc_readbuf(drive);
	}

	return TRUE;
}

/*
 *	D77t@ĆAfBAі̎擾
 */
static int FASTCALL fdc_chkd77(int drive)
{
	int i;
	int handle;
	int count;
	int max_track;
	int trk;
	DWORD offset;
	DWORD len;
	DWORD trkoffset;
	DWORD min_offset;
	BYTE buf[0x2b0];

	/*  */
	for (i=0; i<FDC_MEDIAS; i++) {
		fdc_foffset[drive][i] = 0;
		fdc_name[drive][i][0] = '\0';
	}
	count = 0;
	offset = 0;

	/* t@CI[v */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return count;
	}

	/* fBA[v */
	while (count < FDC_MEDIAS) {
		/* V[N */
		if (!file_seek(handle, offset)) {
			file_close(handle);
			return count;
		}

		/* ǂݍ */
		if (!file_read(handle, buf, 0x02b0)) {
			file_close(handle);
			return count;
		}

		/* ^Cv`FbNB2D,2DD̂ݑΉ */
		if ((buf[0x1b] != 0) && (buf[0x1b] != 0x10)) {
			file_close(handle);
			return count;
		}
		if (buf[0x1b] == 0x00) {
			max_track = 84;
		}
		else {
			max_track = 164;
		}

		/* ANZXĂŏIgbN̎Zo */
		min_offset = (0x0020 + max_track * 4);
		for (trk = 0; trk < max_track; trk++) {
			if ((DWORD)(0x0020 + trk * 4) >= min_offset) {
				break;
			}

			trkoffset = buf[0x20 + trk * 4 + 3];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 2];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 1];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 0];
			if ((trkoffset < min_offset) && (trkoffset >= 0x20)) {
				min_offset = trkoffset;
			}
		}
		max_track = (min_offset - 0x20) / 4;

		/* ok,t@CAItZbgi[ */
		buf[16] = '\0';
		memcpy(fdc_name[drive][count], buf, 17);
		fdc_foffset[drive][count] = offset;

		/* next */
		len = 0;
		len |= buf[0x1f];
		len *= 256;
		len |= buf[0x1e];
		len *= 256;
		len |= buf[0x1d];
		len *= 256;
		len |= buf[0x1c];
		if (len == 0){
			file_close(handle);
			return count;
		}
		for (trk = 0; trk < max_track; trk++) {
			trkoffset = buf[0x20 + trk * 4 + 3];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 2];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 1];
			trkoffset *= 256;
			trkoffset |= buf[0x20 + trk * 4 + 0];
			if (trkoffset >= len) {
				file_close(handle);
				return count;
			}
		}
		offset += len;
		count++;
	}

	/* ő僁fBAɒB */
	file_close(handle);
	return count;
}

/*
 *	VFDt@C`FbN
 */
static int FASTCALL fdc_chkvfd(int drive)
{
	int	i;
	int handle;
	BYTE buf[0x20];

	/*  */
	for (i=0; i<FDC_MEDIAS; i++) {
		fdc_foffset[drive][i] = 0;
		fdc_name[drive][i][0] = '\0';
	}

	/* t@CI[v */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return 0;
	}

	/* wb_̃`FbN */
	if (!file_seek(handle, 0)) {
		file_close(handle);
		return 0;
	}
	if (!file_read(handle, buf, 0x0020)) {
		file_close(handle);
		return 0;
	}
	file_close(handle);

	if (	(buf[0x00] != 0xe0) || (buf[0x01] != 0x01) ||
			(buf[0x02] != 0x00) || (buf[0x03] != 0x00)) {
		/* gbN0̃ItZbg0x01e0ȊOȂVFDł͂Ȃ(蔲c) */
		return 0;
	}

	return 1;
}

/*
 *	FDXt@C`FbN
 */
static int FASTCALL fdc_chkfdx(int drive)
{
	int	i;
	int handle;
	fdxheader_t fdxh;

	/*  */
	for (i=0; i<FDC_MEDIAS; i++) {
		fdc_foffset[drive][i] = 0;
		fdc_name[drive][i][0] = '\0';
	}

	/* t@CI[v */
	handle = file_open(fdc_fname[drive], OPEN_R);
	if (handle == -1) {
		return 0;
	}

	/* wb_̃`FbN */
	if (!file_seek(handle, 0)) {
		file_close(handle);
		return 0;
	}
	if (!file_read(handle, (BYTE *)&fdxh, sizeof(fdxheader_t))) {
		file_close(handle);
		return 0;
	}
	file_close(handle);

	if (fdxh.signature[0] != 'F' ||
		fdxh.signature[1] != 'D' ||
		fdxh.signature[2] != 'X') {
		return 0;
	}

	// rW3̂
	if (fdxh.revision != 3) {
		return 0;
	}

	// RAW^CvȂRATE500RPM300łȂ΂ȂȂ
	if (fdxh.type == FDX_TYPE_RAW) {
		if (fdxh.rate != 4000 || fdxh.rpm != 300) {
			return 0;
		}

		return 1;
	}

	// 2D܂2DDȊO͖T|[g
	if (fdxh.type != FDX_TYPE_2D && fdxh.type != FDX_TYPE_2DD) {
		return 0;
	}

	return 1;
}

/*
 *	fBXNt@Cݒ
 */
int FASTCALL fdc_setdisk(int drive, char *fname)
{
	BOOL writep;
	int handle;
	DWORD fsize;
	int count;
	BOOL flag;
	int i;

	ASSERT((drive >= 0) && (drive < FDC_DRIVES));

	/* mbgfBɂꍇ */
	if (fname == NULL) {
		fdc_ready[drive] = FDC_TYPE_NOTREADY;
		fdc_fname[drive][0] = '\0';
		return 1;
	}

	/* t@CI[vAt@CTCY𒲂ׂ */
	if (strlen(fname) < sizeof(fdc_fname[drive])) {
		strcpy(fdc_fname[drive], fname);
	}
	else {
		fdc_ready[drive] = FDC_TYPE_NOTREADY;
		fdc_fname[drive][0] = '\0';
		return 1;
	}
	writep = FALSE;
	handle = file_open(fdc_fname[drive], OPEN_RW);
	if (handle == -1) {
		handle = file_open(fdc_fname[drive], OPEN_R);
		if (handle == -1) {
			return 0;
		}
		writep = TRUE;
	}
	fsize = file_getsize(handle);
	file_close(handle);

	/*
	 * 2Dt@C
	 */
	if (fsize == 327680) {
		/* ^CvAݑݒ */
		fdc_ready[drive] = FDC_TYPE_2D;
		fdc_fwritep[drive] = writep;

		/* fBAݒ */
		if (!fdc_setmedia(drive, 0)) {
			fdc_ready[drive] = FDC_TYPE_NOTREADY;
			return 0;
		}

		/* BꎞCWFNg */
		fdc_teject[drive] = FALSE;
		fdc_medias[drive] = 1;
		return 1;
	}

	/*
	 * 2DDt@C
	 */
	if (fsize == 655360) {
		/* ^CvAݑݒ */
		fdc_ready[drive] = FDC_TYPE_2DD;
		fdc_fwritep[drive] = writep;

		/* fBAݒ */
		if (!fdc_setmedia(drive, 0)) {
			fdc_ready[drive] = FDC_TYPE_NOTREADY;
			return 0;
		}

		/* BꎞCWFNg */
		fdc_teject[drive] = FALSE;
		fdc_medias[drive] = 1;
		return 1;
	}

	/*
	 * VFDt@C
	 */
	/* t@C */
	if (fdc_chkvfd(drive) != 0) {
		fdc_ready[drive] = FDC_TYPE_VFD;
		fdc_fwritep[drive] = writep;

		/* fBAݒ */
		if (!fdc_setmedia(drive, 0)) {
			fdc_ready[drive] = FDC_TYPE_NOTREADY;
			return 0;
		}

		/* BꎞCWFNg */
		fdc_teject[drive] = FALSE;
		fdc_medias[drive] = 1;
		return 1;
	}

	/*
	 * FDXt@C
	 */
	/* t@C */
	if (fdc_chkfdx(drive) != 0) {
		fdc_ready[drive] = FDC_TYPE_FDX;
		fdc_fwritep[drive] = writep;

		/* fBAݒ */
		if (!fdc_setmedia(drive, 0)) {
			fdc_ready[drive] = FDC_TYPE_NOTREADY;
			return 0;
		}

		/* BꎞCWFNg */
		fdc_teject[drive] = FALSE;
		fdc_medias[drive] = 1;
		return 1;
	}

	/*
	 * D77t@C
	 */
	fdc_ready[drive] = FDC_TYPE_D77;
	fdc_fwritep[drive] = writep;

	/* t@C */
	count = fdc_chkd77(drive);
	if (count == 0){
		fdc_ready[drive] = FDC_TYPE_NOTREADY;
		return 0;
	}

	/* fBAݒ */
	flag = FALSE;
	for (i = 0; i < 16; i++) {
		if (fdc_setmedia(drive, i)) {
			flag = TRUE;
			break;
		}
	}
	if (!flag) {
		fdc_ready[drive] = FDC_TYPE_NOTREADY;
		return 0;
	}

	/* BꎞCWFNg */
	fdc_teject[drive] = FALSE;
	fdc_medias[drive] = (BYTE)count;
	return count;
}

/*-[ FDD Cxg ]-----------------------------------------------------*/

/*
 *	FDC [^[Cxg (WAIT)
 */
static BOOL FASTCALL fdd_mot_event(void)
{
	return TRUE;
}

/*-[ FDCR}h EFCg[h ]---------------------------------------*/

/*
 *	FDC DataRequestCxg (WAIT)
 */
#ifdef FDDSND
static BOOL FASTCALL fdc_drq_event(void)
{
	/* Xgf[^`FbN */
	if (fdc_drqirq & 0x80) {
		return fdc_lost_event();
	}

	/* f[^Ă̂DRQݒ肵Čp */
	if (fdc_dataptr) {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq |= 0x80;
		return TRUE;
	}

	/* f[^ĂȂ̂RECORD NOT FOUNDŏI */
	fdc_status |= FDC_ST_RECNFND;
	fdc_status &= ~FDC_ST_BUSY;
	fdc_access[fdc_drvreg] = FDC_ACCESS_READY;

	/* 荞ݔ */
	mainetc_fdc();
	fdc_drqirq = 0x40;

	return FALSE;
}

/*
 *	FDC V[NCxg (WAIT)
 */
static BOOL FASTCALL fdd_seek_event(void)
{
	/* V[NI */
	if (fdc_seek_track < 0) {
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;

		/* BUSYtO𗎂Ƃ */
		fdc_status &= ~FDC_ST_BUSY;
		fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
		schedule_delevent(EVENT_FDD_SEEK);

		/* wbhďԂNA(Ely) */
		fdc_status &= ~FDC_ST_HEADENG;
	}
	else if (fdc_seek_track-- == 0) {
		/* V[NI̓EFCg} */
		schedule_setevent(EVENT_FDD_SEEK, 20000, fdd_seek_event);
	}
	else {
		/* TEh */
		if (fdc_sound) {
			wav_notify(SOUND_FDDSEEK);
		}
	}

	return TRUE;
}

/*
 *	FDC V[NCxgݒ (SOUND ON)
 */
static void FASTCALL fdc_setseekevent(BYTE track)
{
	/* V[NgbNۑ */
	fdc_seek_track = track;

	/* Cxgݒ */
	if (track > 0) {
		schedule_setevent(EVENT_FDD_SEEK, fdc_steprate[fdc_command & 3], fdd_seek_event);
	}
	else {
		/* wbhړȂĂ΂炭̊ԂBUSYԂɂ */
		schedule_setevent(EVENT_FDD_SEEK, 300, fdd_seek_event);
	}
}
#endif

/*-[ FDCR}h ]----------------------------------------------------------*/

/*
 *	[^[]ʒu擾
 */
static int FASTCALL fdd_get_currentpos(void)
{
	event_t *ev;
	DWORD pos;
	DWORD exec;

	/* ݈ʒu */
	ev = schedule_getevent(EVENT_FDD_MOTOR);
	pos = ev->reload - ev->current;

	/* sȂ玞Ԃ𑫂 */
	if (run_flag) {
		exec = (DWORD)maincpu.total;
		exec *= 10000;
		exec /= schedule_get_cycle();
		pos += exec;
		if (pos >= ev->reload) {
			pos -= ev->reload;
		}
	}

	return (int)pos;
}

/*
 *	ZN^ʒuvZ
 */
static void FASTCALL fdc_calc_pos(void)
{
	int i;
	int max_track;
	int track;
	int gap3;
	int len;
	BYTE *p;
	fdxheader_t *fdxh;
	fdxtrack_t *fdxth;

	ASSERT(fdc_ready[fdc_drvreg] != FDC_TYPE_NOTREADY);

	/* ς݂ȂXLbv */
	if (fdi_init) {
		return;
	}

	/*  */
	fdi_init = TRUE;
	fdi_secs = 0;

	/* fBXN^Cv`FbN */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) ||
		(fdc_ready[fdc_drvreg] == FDC_TYPE_2DD)) {
		track = fdc_track[fdc_drvreg];
#if XM7_VER >= 3
		if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2D) && fdc_2ddmode) {
			/* fBA^Cv(2D) && hCu[h(2DD) */
			track >>= 1;
		}
		else if ((fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) && !fdc_2ddmode) {
			/* fBA^Cv(2DD) && hCu[h(2D) */
			track <<= 1;
		}
#else
		if (fdc_ready[fdc_drvreg] == FDC_TYPE_2DD) {
			/* fBA^Cv(2DD) && hCu[h(2D) */
			track <<= 1;
		}
#endif

#if XM7_VER >= 3
		if (fdc_2ddmode) {
			max_track = 80;
		}
		else {
			max_track = 40;
		}
#else
		max_track = 40;
#endif
		if (track >= max_track) {
			return;
		}

		/* ZN^=16CTCY=256oCgAGAP3=51oCg */
		fdi_secs = 16;
		len = 256;
		gap3 = 51;

		/* ŏ̃ZN^ʒu(ms) */
		fdi_idpos[0] = (80 + 12 + 4 + 50) * 32;
		fdi_dtpos[0] = fdi_idpos[0] + (12 + 4 + 6 + 22) * 32;

		/* ZN^ʒuɌvZ */
		for (i = 1; i < fdi_secs; i++) {
			fdi_idpos[i] = fdi_idpos[i - 1] + (12 + 10 + 22 + 12 + 4 + len + 2 + gap3) * 32;
			fdi_dtpos[i] = fdi_idpos[i] + (12 + 4 + 6 + 22) * 32;
		}
		return;
	}

	if (fdc_ready[fdc_drvreg] == FDC_TYPE_VFD) {
		track = fdc_track[fdc_drvreg];
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			track >>= 1;
		}
#endif
		/* ZN^ */
		fdi_secs = fdc_header[fdc_drvreg][track * 6 + 5];
		if (fdi_secs > 96) {
			fdi_secs = 96;
		}

		if (fdi_secs == 0) {
			return;
		}

		/* TCY */
		len = fdc_header[fdc_drvreg][track * 6 + 4];
		if (len == 0) {
			len = 128;
		}
		else {
			len *= 256;
		}

		/* GAP3 */
		if (fdi_secs <= 5) {
			gap3 = 0x74;
		}
		else {
			if (fdi_secs <= 10) {
				gap3 = 0x54;
			}
			else {
				if (fdi_secs <= 16) {
					gap3 = 0x33;
				}
				else {
					gap3 = 0x10;
				}
			}
		}

		/* ŏ̃ZN^ʒu(ms) */
		fdi_idpos[0] = (80 + 12 + 4 + 50) * 32;
		fdi_dtpos[0] = fdi_idpos[0] + (12 + 4 + 6 + 22) * 32;

		/* ZN^ʒuɌvZ */
		for (i = 1; i < fdi_secs; i++) {
			fdi_idpos[i] = fdi_idpos[i - 1] + (12 + 10 + 22 + 12 + 4 + len + 2 + gap3) * 32;
			fdi_dtpos[i] = fdi_idpos[i] + (12 + 4 + 6 + 22) * 32;
		}
		return;
	}

	if (fdc_ready[fdc_drvreg] == FDC_TYPE_D77) {
		/* ZN^ */
		p = fdc_buffer;
		fdi_secs = p[0x0005];
		fdi_secs *= 256;
		fdi_secs |= p[0x0004];
		if (fdi_secs > 96) {
			fdi_secs = 96;
		}

		if (fdi_secs == 0) {
			return;
		}

		/* GAP3 */
		if (fdi_secs <= 5) {
			gap3 = 0x74;
		}
		else {
			if (fdi_secs <= 10) {
				gap3 = 0x54;
			}
			else {
				if (fdi_secs <= 16) {
					gap3 = 0x33;
				}
				else {
					gap3 = 0x10;
				}
			}
		}

		/* ŏ̃ZN^ʒu(ms) */
		fdi_idpos[0] = (80 + 12 + 4 + 50) * 32;
		fdi_dtpos[0] = fdi_idpos[0] + (12 + 4 + 6 + 22) * 32;

		/* ZN^ʒuɌvZ */
		for (i = 1; i < fdi_secs; i++) {
			/* TCY */
			len = p[0x000f];
			len *= 256;
			len |= p[0x000e];
			fdi_idpos[i] = fdi_idpos[i - 1] + (12 + 10 + 22 + 12 + 4 + len + 2 + gap3) * 32;
			fdi_dtpos[i] = fdi_idpos[i] + (12 + 4 + 6 + 22) * 32;
			p += len + 0x10;
		}
		return;
	}

	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		fdxh = (fdxheader_t *)fdc_header[fdc_drvreg];

		/* ZN^ */
		fdi_secs = fdx_trkstat->num;
		if (fdi_secs > FDX_MAX_SECTOR) {
			fdi_secs = FDX_MAX_SECTOR;
		}

		if (fdi_secs == 0) {
			return;
		}

		/* ZN^ʒuɌvZ */
		if (fdxh->type != FDX_TYPE_RAW) {
			for (i = 0; i < fdi_secs; i++) {
				fdi_idpos[i] = fdx_trkstat->sector[i].idamoffset * 2;
				fdi_dtpos[i] = fdx_trkstat->sector[i].damoffset * 2;
			}
		} else {
			/* RAWf[^̈ʒu琳mȎ(us)ɕϊ */
			fdxth = (fdxtrack_t*)fdx_trkbuf;

			for (i = 0; i < fdi_secs; i++) {
				fdi_idpos[i] = fdx_encode_to_raw_pos(
					fdxth->data, fdxth->length, fdx_trkstat->sector[i].idamoffset);
				fdi_idpos[i] *= 2;
				fdi_idpos[i] /= 8;
				fdi_dtpos[i] = fdx_encode_to_raw_pos(
					fdxth->data, fdxth->length, fdx_trkstat->sector[i].damoffset);
				fdi_dtpos[i] *= 2;
				fdi_dtpos[i] /= 8;
			}
		}
		return;
	}
}

/*
 *	FDC Xe[^X쐬
 */
static void FASTCALL fdc_make_stat(void)
{
#ifdef FDDSND
	int pos;
#endif

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		fdc_status |= FDC_ST_NOTREADY;
		return;
	}

	/* LȃhCu */
	if (fdc_ready[fdc_drvreg] == FDC_TYPE_NOTREADY) {
		fdc_status |= FDC_ST_NOTREADY;
	}
	else {
		fdc_status &= (BYTE)(~FDC_ST_NOTREADY);
	}

	/* ꎞCWFNg */
	if (fdc_teject[fdc_drvreg]) {
		fdc_status |= FDC_ST_NOTREADY;
	}

	/* CgveNg(ReadnR}h0) */
	if ((fdc_cmdtype == 2) || (fdc_cmdtype == 4) || (fdc_cmdtype == 6)) {
		fdc_status &= ~FDC_ST_WRITEP;
	}
	else {
		if (fdc_writep[fdc_drvreg]) {
			fdc_status |= FDC_ST_WRITEP;
		}
		else {
			fdc_status &= ~FDC_ST_WRITEP;
		}
	}

	/* TYPE I ̂ */
	if (fdc_cmdtype != 1) {
		return;
	}

	/* TRACK00 */
	if (fdc_track[fdc_drvreg] == 0) {
		fdc_status |= FDC_ST_TRACK00;
	}
	else {
		fdc_status &= ~FDC_ST_TRACK00;
	}

	/* index */
	if (!(fdc_status & FDC_ST_NOTREADY) && fdc_motor) {
#ifdef FDDSND
		if (fdc_wait) {
			/* UNA */
			fdc_status &= ~FDC_ST_INDEX;

			/* ݂̉]ʒu擾 */
			pos = fdd_get_currentpos();

			/* CfbNXM̎(5000us) */
			if (pos < 5000) {
				fdc_status |= FDC_ST_INDEX;
			}
		} else {
			if (fdc_indexcnt == 0) {
				fdc_status |= FDC_ST_INDEX;
			}
			else {
				fdc_status &= ~FDC_ST_INDEX;
			}
			fdc_next_index();
		}
#else		
		if (fdc_indexcnt == 0) {
			fdc_status |= FDC_ST_INDEX;
		}
		else {
			fdc_status &= ~FDC_ST_INDEX;
		}
		fdc_next_index();
#endif
	}
}

/*
 *	TYPE I
 *	RESTORE
 */
static void FASTCALL fdc_restore(void)
{
#ifdef FDDSND
	BYTE prevtrk;
#endif

	/* TYPE I */
	fdc_cmdtype = 1;
	fdc_status = 0;

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_make_stat();
		return;
	}

#ifdef FDDSND
	/* ݂̃gbNԍۑ */
	prevtrk = fdc_track[fdc_drvreg];
#endif

	/* gbNrAXgAAǂݍ */
	if (fdc_track[fdc_drvreg] != 0) {
		fdc_track[fdc_drvreg] = 0;
		fdc_readbuf(fdc_drvreg);
	}
	fdc_seekvct = TRUE;

	/* Abvf[g(f[^WX^0ɂ) */
	fdc_trkreg = 0;
	fdc_datareg = 0;

	/* FDC荞 */
	fdc_drqirq = 0x00;
#ifdef FDDSND
	if (fdc_wait) {
		fdc_setseekevent(prevtrk);
	}
	else {
		if (!mfd_irq_mask) {
			mainetc_fdc();
			fdc_drqirq |= (BYTE)0x40;
		}
	}
#else
	if (!mfd_irq_mask) {
		mainetc_fdc();
		fdc_drqirq |= (BYTE)0x40;
	}
#endif

	/* Xe[^X */
	fdc_status = FDC_ST_BUSY;
	if (fdc_command & 0x08) {
		fdc_status |= FDC_ST_HEADENG;
	}
	fdc_make_stat();

	/* ANZX(SEEK) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_SEEK;
}

/*
 *	TYPE I
 *	SEEK
 */
static void FASTCALL fdc_seek(void)
{
	BYTE target;
#ifdef FDDSND
	BYTE prevtrk;
#endif

	/* TYPE I */
	fdc_cmdtype = 1;
	fdc_status = 0;

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_make_stat();
		return;
	}

	/* Ƀxt@C */
	if (fdc_command & 0x04) {
		if (fdc_trkreg != fdc_track[fdc_drvreg]) {
			fdc_status |= FDC_ST_SEEKERR;
			/* C(ՂĂ΍) */
			fdc_trkreg = fdc_track[fdc_drvreg];
		}
	}

#ifdef FDDSND
	/* ݂̃gbNԍۑ */
	prevtrk = fdc_track[fdc_drvreg];
#endif

	/* ΃V[N */
	target = (BYTE)(fdc_track[fdc_drvreg] + fdc_datareg - fdc_trkreg);
	if (fdc_datareg > fdc_trkreg) {
		fdc_seekvct = FALSE;
#if XM7_VER >= 3
		if (fdc_2ddmode) {
			if (target > 81) {
				target = 81;
			}
		}
		else {
			if (target > 41) {
				target = 41;
			}
		}
#else
		if (target > 41) {
			target = 41;
		}
#endif
	}
	else {
		fdc_seekvct = TRUE;
		/* gbNԍ̃I[o[t[h~ (OS-9΍) */
		if (fdc_track[fdc_drvreg] < (fdc_trkreg - fdc_datareg)) {
			target = 0;
		}
	}

	/* gbNrAV[NAǂݍ */
	if (fdc_track[fdc_drvreg] != target) {
		fdc_track[fdc_drvreg] = target;
		fdc_readbuf(fdc_drvreg);
	}

	/* Abvf[g */
	fdc_trkreg = fdc_datareg;	/* f[^WX^̒lf͗l */

	/* FDC荞 */
	fdc_drqirq = 0x00;
#ifdef FDDSND
	if (fdc_wait) {
		fdc_setseekevent((BYTE)abs(target - prevtrk));
	}
	else {
		if (!mfd_irq_mask) {
			mainetc_fdc();
			fdc_drqirq |= (BYTE)0x40;
		}
	}
#else
	if (!mfd_irq_mask) {
		mainetc_fdc();
		fdc_drqirq |= (BYTE)0x40;
	}
#endif

	/* Xe[^X */
	fdc_status |= FDC_ST_BUSY;
	if (fdc_command & 0x08) {
		fdc_status |= FDC_ST_HEADENG;
	}
	fdc_make_stat();

	/* ANZX(SEEK) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_SEEK;
}

/*
 *	TYPE I
 *	STEP IN
 */
static void FASTCALL fdc_step_in(void)
{
#ifdef FDDSND
	BYTE prevtrk;
#endif

	/* TYPE I */
	fdc_cmdtype = 1;
	fdc_status = 0;

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_make_stat();
		return;
	}

#ifdef FDDSND
	/* ݂̃gbNԍۑ */
	prevtrk = fdc_track[fdc_drvreg];
#endif

	/* Ƀxt@C */
	if (fdc_command & 0x04) {
		if (fdc_trkreg != fdc_track[fdc_drvreg]) {
			fdc_status |= FDC_ST_SEEKERR;
		}
	}

	/* XebvAǂݍ */
#if XM7_VER >= 3
	if (fdc_2ddmode) {
		if (fdc_track[fdc_drvreg] < 81) {
			fdc_track[fdc_drvreg]++;
			fdc_readbuf(fdc_drvreg);
		}
	}
	else {
		if (fdc_track[fdc_drvreg] < 41) {
			fdc_track[fdc_drvreg]++;
			fdc_readbuf(fdc_drvreg);
		}
	}
#else
	if (fdc_track[fdc_drvreg] < 41) {
		fdc_track[fdc_drvreg]++;
		fdc_readbuf(fdc_drvreg);
	}
#endif
	fdc_seekvct = FALSE;

	/* Abvf[g */
	if (fdc_command & 0x10) {
		if (fdc_trkreg < 255) {
			fdc_trkreg++;	/* gbNWX^̂̍XV݂̂Ǝv */
		}
	}

	/* FDC荞 */
	fdc_drqirq = 0x00;
#ifdef FDDSND
	if (fdc_wait && (prevtrk != fdc_track[fdc_drvreg])) {
		fdc_setseekevent(1);
	}
	else {
		if (!mfd_irq_mask) {
			mainetc_fdc();
			fdc_drqirq |= (BYTE)0x40;
		}
	}
#else
	if (!mfd_irq_mask) {
		mainetc_fdc();
		fdc_drqirq |= (BYTE)0x40;
	}
#endif

	/* Xe[^X */
	fdc_status |= FDC_ST_BUSY;
	if (fdc_command & 0x08) {
		fdc_status |= FDC_ST_HEADENG;
	}
	fdc_make_stat();

	/* ANZX(SEEK) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_SEEK;
}

/*
 *	TYPE I
 *	STEP OUT
 */
static void FASTCALL fdc_step_out(void)
{
#ifdef FDDSND
	BYTE prevtrk;
#endif

	/* TYPE I */
	fdc_cmdtype = 1;
	fdc_status = 0;

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_make_stat();
		return;
	}

#ifdef FDDSND
	/* ݂̃gbNԍۑ */
	prevtrk = fdc_track[fdc_drvreg];
#endif

	/* Ƀxt@C */
	if (fdc_command & 0x04) {
		if (fdc_trkreg != fdc_track[fdc_drvreg]) {
			fdc_status |= FDC_ST_SEEKERR;
		}
	}

	/* XebvAǂݍ */
	if (fdc_track[fdc_drvreg] != 0) {
		fdc_track[fdc_drvreg]--;
		fdc_readbuf(fdc_drvreg);
	}
	fdc_seekvct = TRUE;

	/* Abvf[g */
	if (fdc_command & 0x10) {
		if (fdc_trkreg > 0) {
			fdc_trkreg--;	/* gbNWX^̂̍XV݂̂Ǝv */
		}
	}

	/* FDC荞 */
	fdc_drqirq = 0x00;
#ifdef FDDSND
	if (fdc_wait && (prevtrk != fdc_track[fdc_drvreg])) {
		fdc_setseekevent(1);
	}
	else {
		if (!mfd_irq_mask) {
			mainetc_fdc();
			fdc_drqirq |= (BYTE)0x40;
		}
	}
#else
	if (!mfd_irq_mask) {
		mainetc_fdc();
		fdc_drqirq |= (BYTE)0x40;
	}
#endif

	/* Xe[^X */
	fdc_status |= FDC_ST_BUSY;
	if (fdc_command & 0x08) {
		fdc_status |= FDC_ST_HEADENG;
	}
	fdc_make_stat();

	/* ANZX(SEEK) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_SEEK;
}

/*
 *	TYPE I
 *	STEP
 */
static void FASTCALL fdc_step(void)
{
	if (fdc_seekvct) {
		fdc_step_out();
	}
	else {
		fdc_step_in();
	}
}

/*
 *	TYPE II, III
 *	READ/WRITE Tu
 */
static BOOL FASTCALL fdc_rw_sub(void)
{
	fdc_status = 0;

	/* hCu`FbN */
	if (fdc_drvreg >= FDC_DRIVES) {
		fdc_make_stat();
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		return FALSE;
	}

	/* NOT READY`FbN */
	if ((fdc_ready[fdc_drvreg] == FDC_TYPE_NOTREADY) || fdc_teject[fdc_drvreg]) {
		fdc_make_stat();
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		return FALSE;
	}

	return TRUE;
}

/*
 *	TYPE II
 *	READ DATA
 */
static void FASTCALL fdc_read_data(void)
{
	BYTE stat;
	int secidx;
	int time;

	/* TYPE II, Read */
	fdc_cmdtype = 2;

	/* {`FbN */
	if (!fdc_rw_sub()) {
		return;
	}

#ifdef FDDSND
	if (fdc_wait) {
		/* |WVݒ */
		fdc_calc_pos();
	}
#endif

	/* ZN^ */
	if (fdc_command & 0x02) {
		stat = fdc_readsec(
			fdc_trkreg, fdc_secreg, (BYTE)((fdc_command & 0x08) >> 3),
			TRUE, &secidx, fdd_get_currentpos());
	}
	else {
		stat = fdc_readsec(
			fdc_trkreg, fdc_secreg, fdc_sidereg,
			FALSE, &secidx, fdd_get_currentpos());
	}

	/* ɃXe[^Xݒ肷 */
	fdc_status = stat;

	/* RECORD NOT FOUND ? */
	if (fdc_status & FDC_ST_RECNFND) {
		/* ]f[^ */
		fdc_dataptr = NULL;
		fdc_datareg = 0x00;
#ifdef FDDSND
		if (fdc_wait) {
			/* Cxg܂łBUSY */
			fdc_status |= FDC_ST_BUSY;

			/* tONAăCxgōĐݒ肷 */
			fdc_status &= ~FDC_ST_RECNFND;
			schedule_setevent(EVENT_FDC_L, FDD_ROTATION_TIME * 6, fdc_drq_event);
			fdc_access[fdc_drvreg] = FDC_ACCESS_READ;
			return;
		}
#endif
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
		return;
	}

	/* ŏ̃f[^ݒ */
	fdc_status |= FDC_ST_BUSY;
	fdc_datareg = fdc_dataptr[0];
#ifdef FDDSND
	if (fdc_wait) {
		/* YZN^܂ł̎ */
		time = 0;
		if (secidx < fdi_secs) {
			time = fdi_dtpos[secidx] - fdd_get_currentpos();
		}
		if (time <= 0) {
			time += FDD_ROTATION_TIME;
		}

		/* ZN^܂ł̗\莞Ԃݒ */
		schedule_setevent(EVENT_FDC_L, (DWORD)time, fdc_drq_event);
		fdc_drqirq = 0x00;
	}
	else {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq = 0x80;
	}
#else
	fdc_status |= FDC_ST_DRQ;
	fdc_drqirq = 0x80;
#endif

	/* ANZX(READ) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_READ;

	/* DMA]JnAXgf[^Cxgݒ */
#if XM7_VER >= 3
	dmac_start();
#endif
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_setevent(EVENT_FDC_L, 30 * 1000, fdc_lost_event);
	}
#else
	schedule_setevent(EVENT_FDC_L, 30 * 1000, fdc_lost_event);
#endif
}

/*
 *	TYPE II
 *	WRITE DATA
 */
static void FASTCALL fdc_write_data(void)
{
	BYTE stat;
	int secidx;
	int time;

	/* TYPE II, Write */
	fdc_cmdtype = 3;

	/* {`FbN */
	if (!fdc_rw_sub()) {
		return;
	}

	/* WRITE PROTECT`FbN */
	if (fdc_writep[fdc_drvreg] != 0) {
		fdc_make_stat();
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		return;
	}

#ifdef FDDSND
	if (fdc_wait) {
		/* |WVݒ */
		fdc_calc_pos();
	}
#endif

	/* ZN^ */
	if (fdc_command & 0x02) {
		stat = fdc_readsec(
			fdc_trkreg, fdc_secreg, (BYTE)((fdc_command & 0x08) >> 3),
			TRUE, &secidx, fdd_get_currentpos());
	}
	else {
		stat = fdc_readsec(
			fdc_trkreg, fdc_secreg, fdc_sidereg,
			FALSE, &secidx, fdd_get_currentpos());
	}

	/* ɃXe[^Xݒ肷 */
	fdc_status = stat;

	/* RECORD NOT FOUND ? */
	if (fdc_status & FDC_ST_RECNFND) {
		/* ]f[^ */
		fdc_dataptr = NULL;
		fdc_datareg = 0x00;
#ifdef FDDSND
		if (fdc_wait) {
			/* Cxg܂łBUSY */
			fdc_status |= FDC_ST_BUSY;

			/* tONAăCxgŐݒ肷 */
			fdc_status &= ~FDC_ST_RECNFND;
			schedule_setevent(EVENT_FDC_L, FDD_ROTATION_TIME * 6, fdc_drq_event);
			fdc_access[fdc_drvreg] = FDC_ACCESS_WRITE;
			return;
		}
#endif
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
		return;
	}

	/* DRQ */
#ifdef FDDSND
	fdc_status |= FDC_ST_BUSY;
	if (fdc_wait) {
		/* YZN^܂ł̎ */
		time = 0;
		if (secidx < fdi_secs) {
			time = fdi_dtpos[secidx] - fdd_get_currentpos();
		}
		if (time <= 0) {
			time += FDD_ROTATION_TIME;
		}

		/* ZN^܂ł̗\莞Ԃݒ */
		schedule_setevent(EVENT_FDC_L, (DWORD)time, fdc_drq_event);
		fdc_drqirq = 0x00;
	}
	else {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq = 0x80;
	}
#else
	fdc_status = FDC_ST_BUSY | FDC_ST_DRQ;
	fdc_drqirq = 0x80;
#endif

	/* ANZX(WRITE) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_WRITE;

	/* DMA]JnAXgf[^Cxgݒ */
#if XM7_VER >= 3
	dmac_start();
#endif
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_setevent(EVENT_FDC_L, 30 * 1000, fdc_lost_event);
	}
#else
	schedule_setevent(EVENT_FDC_L, 30 * 1000, fdc_lost_event);
#endif
}

/*
 *	TYPE III
 *	READ ADDRESS
 */
static void FASTCALL fdc_read_addr(void)
{
	int i;
	int cur;
	int idx;
	int time;

	/* TYPE III, Read Address */
	fdc_cmdtype = 4;

	/* {`FbN */
	if (!fdc_rw_sub()) {
		return;
	}

#ifdef FDDSND
	if (fdc_wait) {
		/* C[W̃ZN^ʒuvZ */
		fdc_calc_pos();

		/* ݂̉]ʒu */
		cur = fdd_get_currentpos();

		/* ߂̃ZN^T */
		idx = -1;
		time = 0;
		if (fdi_secs > 0) {
			for (i = 0; i < fdi_secs; i++) {
				if (fdi_idpos[i] < FDD_ROTATION_TIME && fdi_idpos[i] > cur) {
					break;
				}
			}

			/* ZN^m */
			idx = i;
			if (idx == fdi_secs) {
				idx = 0;
			}

			/* ݈ʒu̎ */
			time = fdi_idpos[idx] - cur;
			if (time <= 0) {
				time += FDD_ROTATION_TIME;
			}
		}
	} else {
		/* gbN擪̑΃ZN^ԍ擾 */
		idx = fdc_next_index();
	}
#else
	/* gbN擪̑΃ZN^ԍ擾 */
	idx = fdc_next_index();
#endif

	/* AtH[}bg`FbN */
	if (idx == -1) {
		/* ]f[^ */
		fdc_dataptr = NULL;
		fdc_datareg = 0x00;
#ifdef FDDSND
		if (fdc_wait) {
			/* Cxg܂łBUSY */
			fdc_status |= FDC_ST_BUSY;

			/* tONAăCxgŐݒ肷 */
			fdc_status &= ~FDC_ST_RECNFND;
			schedule_setevent(EVENT_FDC_L, FDD_ROTATION_TIME * 6, fdc_drq_event);
			fdc_access[fdc_drvreg] = FDC_ACCESS_READ;
			return;
		}
#endif
		/* RECORD NOT FOUND */
		fdc_status |= FDC_ST_RECNFND;

		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
		return;
	}

	/* f[^쐬 */
	fdc_makeaddr(idx);

	/* ŏ̃f[^ݒ */
	fdc_status |= FDC_ST_BUSY;
	fdc_datareg = fdc_dataptr[0];
#ifdef FDDSND
	if (fdc_wait) {
		schedule_setevent(EVENT_FDC_L, (DWORD)time, fdc_drq_event);
		fdc_drqirq = 0x00;
	}
	else {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq = 0x80;
	}
#else
	fdc_status |= FDC_ST_DRQ;
	fdc_drqirq = 0x80;
#endif

	/* ANZX(READ) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_READ;

	/* DMA]JnAXgf[^Cxgݒ */
#if XM7_VER >= 3
	dmac_start();
#endif
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_setevent(EVENT_FDC_L, 10 * 1000, fdc_lost_event);
	}
#else
	schedule_setevent(EVENT_FDC_L, 10 * 1000, fdc_lost_event);
#endif
}

/*
 *	TYPE III
 *	READ TRACK
 */
static void FASTCALL fdc_read_track(void)
{
	int time;

	/* TYPE III, Read Track */
	fdc_cmdtype = 6;

	/* {`FbN */
	if (!fdc_rw_sub()) {
		return;
	}

	/* f[^쐬 */
	fdc_make_track();

	/* ŏ̃f[^ݒ */
	fdc_status |= FDC_ST_BUSY;
	fdc_datareg = fdc_dataptr[0];
#ifdef FDDSND
	if (fdc_wait) {
		time = FDD_ROTATION_TIME - fdd_get_currentpos();
		if (time <= 0) {
			time = FDD_ROTATION_TIME;
		}
		schedule_setevent(EVENT_FDC_L, (DWORD)time, fdc_drq_event);
		fdc_drqirq = 0x00;
	}
	else {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq = 0x80;
	}
#else
	fdc_status |= FDC_ST_DRQ;
	fdc_drqirq = 0x80;
#endif

	/* ANZX(READ) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_READ;

	/* DMA]JnAXgf[^Cxgݒ */
#if XM7_VER >= 3
	dmac_start();
#endif
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_setevent(EVENT_FDC_L, 150 * 1000, fdc_lost_event);
	}
#else
	schedule_setevent(EVENT_FDC_L, 150 * 1000, fdc_lost_event);
#endif
}

/*
 *	TYPE III
 *	WRITE TRACK
 */
static void FASTCALL fdc_write_track(void)
{
	int time;

	/* TYPE III, Write */
	fdc_cmdtype = 5;

	/* {`FbN */
	if (!fdc_rw_sub()) {
		return;
	}

	/* WRITE PROTECT`FbN */
	if (fdc_writep[fdc_drvreg] != 0) {
		fdc_make_stat();
		/* FDC荞 */
		mainetc_fdc();
		fdc_drqirq = 0x40;
		return;
	}

	/* DRQ */
#ifdef FDDSND
	fdc_status |= FDC_ST_BUSY;
	if (fdc_wait) {
		time = FDD_ROTATION_TIME - fdd_get_currentpos();
		if (time <= 0) {
			time = FDD_ROTATION_TIME;
		}
		schedule_setevent(EVENT_FDC_L, (DWORD)time, fdc_drq_event);
		fdc_drqirq = 0x00;
	}
	else {
		fdc_status |= FDC_ST_DRQ;
		fdc_drqirq = 0x80;
	}
#else
	fdc_status = FDC_ST_BUSY | FDC_ST_DRQ;
	fdc_drqirq = 0x80;
#endif

	fdc_dataptr = fdc_buffer;
	fdc_totalcnt = 0x1800;
	fdc_onetime = 32;
	fdc_nowcnt = 0;

	/* ANZX(WRITE) */
	fdc_access[fdc_drvreg] = FDC_ACCESS_WRITE;

	/* DMA]JnAXgf[^Cxgݒ */
#if XM7_VER >= 3
	dmac_start();
#endif
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_setevent(EVENT_FDC_L, 150 * 1000, fdc_lost_event);
	}
#else
	schedule_setevent(EVENT_FDC_L, 150 * 1000, fdc_lost_event);
#endif
}

/*
 *	TYPE IV
 *	FORCE INTERRUPT
 */
static void FASTCALL fdc_force_intr(void)
{
	/* WRITE TRACKI */
	if (fdc_cmdtype == 5) {
		if (!fdc_writetrk()) {
			fdc_status |= FDC_ST_WRITEFAULT;
		}
	}

	/* ANZX~ */
#ifdef FDDSND
	if (!fdc_wait) {
		schedule_delevent(EVENT_FDC_L);
	}
#endif

	/* obt@C */
	fdc_readbuf(fdc_drvreg);
	fdc_dataptr = NULL;

	/* Xe[^X */
	switch (fdc_access[fdc_drvreg]) {
		case FDC_ACCESS_READ:
		case FDC_ACCESS_WRITE:
			/* s̃R}hƓXe[^X */
			fdc_status &= ~FDC_ST_BUSY;
			break;

		case FDC_ACCESS_SEEK:
		case FDC_ACCESS_READY:
			fdc_status = 0;
			fdc_indexcnt = 0;
			fdc_make_stat();
			break;
	}

	/* ŃANZXREADY */
	fdc_access[fdc_drvreg] = FDC_ACCESS_READY;

	/* ꂩĂ΁AIRQ(ƂĂ͕s\) */
	if (fdc_command & 0x0f) {
		mainetc_fdc();
		fdc_drqirq = 0x40;
	}
	else {
		fdc_drqirq = 0x00;
	}
}

/*
 *	}`ZN^
 *	Cxg
 */
static BOOL FASTCALL fdc_multi_event(void)
{
	if (fdc_drqirq & 0x10) {
		fdc_drqirq = 0x08;
		/* ZN^WX^UpAZN^ */
		fdc_secreg++;
		schedule_setevent(EVENT_FDC_M, 30, fdc_multi_event);
		return TRUE;
	}

	if (fdc_drqirq & 0x08) {
		fdc_drqirq = 0x00;
		/* ZN^ */
		if (fdc_cmdtype == 2) {
			fdc_read_data();
			fdc_drqirq |= 0x20;
		}
		if (fdc_cmdtype == 3) {
			fdc_write_data();
			fdc_drqirq |= 0x20;
		}
	}

	/* Cxg폜ďI */
	schedule_delevent(EVENT_FDC_M);
	return TRUE;
}

/*
 *	Xgf[^
 *	Cxg
 */
static BOOL FASTCALL fdc_lost_event(void)
{
	if (fdc_dataptr && (fdc_drqirq & 0x80)) {
		/* R}hł؂AXgf[^ */
		fdc_dataptr = NULL;
		fdc_status |= FDC_ST_LOSTDATA;
		fdc_status &= ~FDC_ST_DRQ;
		fdc_status &= ~FDC_ST_BUSY;
		fdc_access[fdc_drvreg] = FDC_ACCESS_READY;

		/* 荞ݔ */
		mainetc_fdc();
		fdc_drqirq = 0x40;
	}

	/* Cxg폜ďI */
	schedule_delevent(EVENT_FDC_L);
	return TRUE;
}


/*
 *	R}h
 */
static void FASTCALL fdc_process_cmd(void)
{
	BYTE high;

	high = (BYTE)(fdc_command >> 4);

#ifdef FDDSND
	/* EFCgtOݒ */
	fdc_wait = fdc_waitmode;
#endif

	/* f[^]sĂ΁A~߂ */
	fdc_dataptr = NULL;

	/*  */
	switch (high) {
		/* restore */
		case 0x00:
			fdc_restore();
			break;
		/* seek */
		case 0x01:
			fdc_seek();
			break;
		/* step */
		case 0x02:
		case 0x03:
			fdc_step();
			break;
		/* step in */
		case 0x04:
		case 0x05:
			fdc_step_in();
			break;
		/* step out */
		case 0x06:
		case 0x07:
			fdc_step_out();
			break;
		/* read data */
		case 0x08:
		case 0x09:
			fdc_read_data();
			break;
		/* write data */
		case 0x0a:
		case 0x0b:
			fdc_write_data();
			break;
		/* read address */
		case 0x0c:
			fdc_read_addr();
			break;
		/* force interrupt */
		case 0x0d:
			fdc_force_intr();
			break;
		/* read track */
		case 0x0e:
			fdc_read_track();
			break;
		/* write track */
		case 0x0f:
			fdc_write_track();
			break;
		/* ȊO */
		default:
			ASSERT(FALSE);
			break;
	}
}

/*
 *	FDC
 *	PoCgǂݏo
 */
BOOL FASTCALL fdc_readb(WORD addr, BYTE *dat)
{
#if XM7_VER >= 3
	BYTE tmp;
#endif
	event_t *ev;

	switch (addr) {
		/* Xe[^XWX^ */
		case 0xfd18:
			fdc_make_stat();
			*dat = fdc_status;
			/* Xe[^X`FbN() */
			fdc_drqirq |= (BYTE)0x20;
			/* BUSY */
			if ((fdc_status & FDC_ST_BUSY) && (fdc_dataptr == NULL)) {
#ifdef FDDSND
				if (!fdc_wait && (fdc_cmdtype == 1)) {
#else
				if (fdc_cmdtype == 1) {
#endif
					/* IRQ On */
					fdc_drqirq |= (BYTE)0x40;
				}
#ifdef FDDSND
				if (!fdc_wait || (fdc_cmdtype != 1) || (fdc_drqirq & 0x40)) {
					/* BUSYtO𗎂Ƃ */
					fdc_status &= ~FDC_ST_BUSY;
					fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
				}
#else
				/* BUSYtO𗎂Ƃ */
				fdc_status &= ~FDC_ST_BUSY;
				fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
#endif
				/* xBUSY */
				return TRUE;
			}
			/* FDC荞݂AŎ~߂ */
			mfd_irq_flag = FALSE;
			fdc_drqirq &= ~0x40;
			maincpu_irq();
			return TRUE;

		/* gbNWX^ */
		case 0xfd19:
			*dat = fdc_trkreg;
			return TRUE;

		/* ZN^WX^ */
		case 0xfd1a:
			*dat = fdc_secreg;
			return TRUE;

		/* f[^WX^ */
		case 0xfd1b:
			*dat = fdc_datareg;
			/* JE^ */
			if (fdc_dataptr && (fdc_drqirq & 0x20)) {
				fdc_nowcnt++;
				/* DRQ,IRQ */
				if (fdc_nowcnt == fdc_totalcnt) {
#ifdef FDDSND
					if (fdc_wait) {
						schedule_delevent(EVENT_FDC_L);
					}
#endif
					fdc_status &= ~FDC_ST_BUSY;
					fdc_status &= ~FDC_ST_DRQ;
					fdc_drqirq &= (BYTE)~0x80;

					if ((fdc_cmdtype == 2) && (fdc_command & 0x10)) {
						/* }`ZN^ */
						fdc_status |= FDC_ST_BUSY;
						fdc_dataptr = NULL;
						fdc_drqirq = 0x10;
						schedule_setevent(EVENT_FDC_M, 30, fdc_multi_event);
						return TRUE;
					}
					/* VOZN^ */
					fdc_dataptr = NULL;
					mainetc_fdc();
					fdc_drqirq = 0x40;
					fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
					/* Read Track͕KLOST DATAAobt@C */
					if (fdc_cmdtype == 6) {
						fdc_status |= FDC_ST_LOSTDATA;
						fdc_readbuf(fdc_drvreg);
					}
				}
				else {
					fdc_datareg = fdc_dataptr[fdc_nowcnt];
#ifdef FDDSND
					if (fdc_wait) {
						/* 1oCg]ԂقȂƂĐݒ */
						ev = schedule_getevent(EVENT_FDC_L);
						if (!ev->flag || ev->reload != fdc_onetime) {
							schedule_setevent(
								EVENT_FDC_L, (DWORD)fdc_onetime, fdc_drq_event);
						}

						fdc_status &= (BYTE)~FDC_ST_DRQ;
						fdc_drqirq &= (BYTE)~0x80;
					}
					else {
						fdc_drqirq |= (BYTE)0x80;
					}
#else
					fdc_drqirq |= (BYTE)0x80;
#endif
				}
			}
			return TRUE;

		/* wbhWX^ */
		case 0xfd1c:
			*dat = (BYTE)(fdc_sidereg | 0xfe);
			return TRUE;

		/* hCuWX^ */
		case 0xfd1d:
#if XM7_VER >= 3
			if (fdc_motor) {
				*dat = (BYTE)(0xbc | fdc_drvregP);
			}
			else {
				*dat = (BYTE)(0x3c | fdc_drvregP);
			}
#else
			if (fdc_motor) {
				*dat = (BYTE)(0xbc | fdc_drvreg);
			}
			else {
				*dat = (BYTE)(0x3c | fdc_drvreg);
			}
#endif
			return TRUE;

		/* [hWX^ */
		case 0xfd1e:
#if XM7_VER >= 3
			if (fm7_ver < 3) {
				*dat = 0xff;
				return TRUE;
			}

			/* _hCuEhCuΉǂݏo */
			tmp = (BYTE)(fdc_logidrv << 2) | (fdc_physdrv[fdc_logidrv]);
			/* 2DD[hǂݏo */
			if (fdc_2ddmode) {
				*dat = (BYTE)(tmp | 0xb0);
			}
			else {
				*dat = (BYTE)(tmp | 0xf0);
			}
#else
			*dat = 0xFF;
#endif
			return TRUE;

		/* DRQ,IRQ */
		case 0xfd1f:
			*dat = (BYTE)(fdc_drqirq | 0x3f);
			/* DRQ܂IRQ`FbN() */
			fdc_drqirq |= (BYTE)0x20;
			/* f[^]ŖΏI(z̐_a) */
			if (fdc_dataptr == NULL) {
#ifdef FDDSND
				if (!fdc_wait && (fdc_cmdtype == 1) && (fdc_status & FDC_ST_BUSY)) {
#else
				if ((fdc_cmdtype == 1) && (fdc_status & FDC_ST_BUSY)) {
#endif
					/* IRQ On */
					fdc_drqirq |= (BYTE)0x40;
				}
#ifdef FDDSND
				if (!fdc_wait || (fdc_cmdtype != 1) || (fdc_drqirq & 0x40)) {
					/* BUSYtO𗎂Ƃ */
					fdc_status &= ~FDC_ST_BUSY;
					fdc_access[fdc_drvreg] = FDC_ACCESS_READY;

					/* wbhďԂNA(Ely) */
					if (fdc_cmdtype == 1) {
						fdc_status &= ~FDC_ST_HEADENG;
					}
				}
#else
				/* BUSYtO𗎂Ƃ */
				fdc_status &= ~FDC_ST_BUSY;
				fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
#endif
			}
			return TRUE;
	}

	return FALSE;
}

/*
 *	FDC
 *	PoCg
 */
BOOL FASTCALL fdc_writeb(WORD addr, BYTE dat)
{
#if XM7_VER >= 3
	BOOL tmp;
#endif
	event_t *ev;

	switch (addr) {
		/* R}hWX^ */
		case 0xfd18:
#if XM7_VER >= 2
			if (fm7_ver >= 2) {
				fdc_dsenable = 0x00;	/* R}hsDS ENABLEԂƂ */
			}
#endif
			fdc_command = dat;
			fdc_process_cmd();
			return TRUE;

		/* gbNWX^ */
		case 0xfd19:
			fdc_trkreg = dat;
			/* R}hs̃gbNWX^΍ */
			/* (F-BASIC V3.3L3x/V3.4L2x VOLCOPY/SUBSET(VCOPYEB)) */
			if (((fdc_status & FDC_ST_BUSY) && (fdc_nowcnt == 0)) &&
				((fdc_cmdtype == 2) || (fdc_cmdtype == 3))) {
				fdc_process_cmd();
			}
			return TRUE;

		/* ZN^WX^ */
		case 0xfd1a:
			fdc_secreg = dat;
			/* R}hs̃ZN^WX^΍ */
			/* (F-BASIC V3.3L3x/V3.4L2x VOLCOPY/SUBSET(VCOPYEB)) */
			if (((fdc_status & FDC_ST_BUSY) && (fdc_nowcnt == 0)) &&
				((fdc_cmdtype == 2) || (fdc_cmdtype == 3))) {
				fdc_process_cmd();
			}
			return TRUE;

		/* f[^WX^ */
		case 0xfd1b:
			fdc_datareg = dat;
			/* JE^ */
			if (fdc_dataptr && (fdc_drqirq & 0x20)) {
				fdc_dataptr[fdc_nowcnt] = fdc_datareg;
				fdc_nowcnt++;
				/* DRQ,IRQ */
				if (fdc_nowcnt == fdc_totalcnt) {
#ifdef FDDSND
					if (fdc_wait) {
						schedule_delevent(EVENT_FDC_L);
					}
#endif
					fdc_status &= ~FDC_ST_DRQ;
					fdc_drqirq &= (BYTE)(~0x80);
					fdc_status &= ~FDC_ST_BUSY;

					if (fdc_cmdtype == 3) {
						if (!fdc_writesec()) {
							fdc_status |= FDC_ST_WRITEFAULT;
						}
					}
					if (fdc_cmdtype == 5) {
						if (!fdc_writetrk()) {
							fdc_status |= FDC_ST_WRITEFAULT;
						}
						/* tH[}bĝߎgpobt@C */
						fdc_readbuf(fdc_drvreg);
					}
					if ((fdc_cmdtype == 3) && (fdc_command & 0x10)) {
						/* }`ZN^ */
						fdc_status |= FDC_ST_BUSY;
						fdc_dataptr = NULL;
						fdc_drqirq = 0x10;
						schedule_setevent(EVENT_FDC_M, 30, fdc_multi_event);
						return TRUE;
					}
					fdc_dataptr = NULL;
					mainetc_fdc();
					fdc_drqirq = 0x40;
					fdc_access[fdc_drvreg] = FDC_ACCESS_READY;
				}
				else {
#ifdef FDDSND
					if (fdc_wait) {
						/* 1oCg]ԂقȂƂĐݒ */
						ev = schedule_getevent(EVENT_FDC_L);
						if (!ev->flag || ev->reload != fdc_onetime) {
							schedule_setevent(
								EVENT_FDC_L, (DWORD)fdc_onetime, fdc_drq_event);
						}

						fdc_status &= (BYTE)~FDC_ST_DRQ;
						fdc_drqirq &= (BYTE)~0x80;
					}
					else {
						fdc_drqirq |= (BYTE)0x80;
					}
#else
					fdc_drqirq |= (BYTE)0x80;
#endif
				}
			}
			return TRUE;

		/* wbhWX^ */
		case 0xfd1c:
			if ((dat & 0x01) != fdc_sidereg) {
				fdc_sidereg = (BYTE)(dat & 0x01);
				fdc_readbuf(fdc_drvreg);
			}
			return TRUE;

		/* hCuWX^ */
		case 0xfd1d:
			/* hCuύXȂAfdc_readbuf */
#if XM7_VER >= 3
			if (fdc_drvregP != (dat & 0x03)) {
				fdc_drvregP = (BYTE)(dat & 0x03);
				fdc_drvreg = (BYTE)fdc_physdrv[fdc_drvregP];
				fdc_readbuf(fdc_drvreg);
			}
#else
			if (fdc_drvreg != (dat & 0x03)) {
				fdc_drvreg = (BYTE)(dat & 0x03);
				fdc_readbuf(fdc_drvreg);
			}
#endif
			fdc_motor = (BYTE)(dat & 0x80);
			/* hCuȂA[^~߂ */
			if (fdc_drvreg >= FDC_DRIVES) {
				fdc_motor = 0;
			}

			/* [^[Cxg */
			ev = schedule_getevent(EVENT_FDD_MOTOR);
			if (fdc_motor) {
				if (ev->flag == EVENT_NOTUSE) {
					schedule_setevent(EVENT_FDD_MOTOR, FDD_ROTATION_TIME, fdd_mot_event);
				}
			} else {
				if (ev->flag == EVENT_ENABLED) {
					schedule_delevent(EVENT_FDD_MOTOR);
				}
			}

#if XM7_VER >= 2
			/* DS ENABLE͋L̂(ۂɎgpɂ͋@ˑ̑ΉKv) */
			if (fm7_ver >= 2) {
				fdc_dsenable = (BYTE)(dat & 0x40);
			}
#endif
			return TRUE;

		/* [hWX^ */
		case 0xfd1e:
#if XM7_VER >= 3
			if (fm7_ver < 3) {
				return TRUE;
			}

			/* 2DD؂芷 */
			tmp = fdc_2ddmode;

			if (dat & 0x40) {
				fdc_2ddmode = FALSE;
			}
			else {
				fdc_2ddmode = TRUE;
			}

			/* _hCuƕhCȗΉύX */
			fdc_logidrv = (BYTE)((dat & 0x0c) >> 2);
			if (dat & 0x10) {
				/*  */
				fdc_physdrv[fdc_logidrv] = (BYTE)(dat & 0x03);

				/* JghCu̐ݒ肪ύXꂽꍇ̏ */
				if (fdc_logidrv == fdc_drvregP) {
					fdc_drvreg = (BYTE)fdc_physdrv[fdc_logidrv];
					fdc_readbuf(fdc_drvreg);
					return TRUE;
				}
			}

			/* 2DD؂芷sꂽꍇ͍ēǂݍ */
			if (fdc_2ddmode != tmp) {
				fdc_readbuf(fdc_drvreg);
			}
#endif
			return TRUE;
	}

	return FALSE;
}

/*
 *	FDC
 *	Z[u
 */
BOOL FASTCALL fdc_save(int fileh)
{
	int i;

	/* t@C֌WɎĂ */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_write(fileh, fdc_ready[i])) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_write(fileh, (BYTE*)fdc_fname[i], 256 + 1)) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_write(fileh, fdc_media[i])) {
			return FALSE;
		}
	}

	/* Ver4g */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_bool_write(fileh, fdc_teject[i])) {
			return FALSE;
		}
	}

	/* t@CXe[^X */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_write(fileh, fdc_track[i])) {
			return FALSE;
		}
	}
	if (!file_write(fileh, fdc_buffer, 0x2000)) {
		return FALSE;
	}

	/* fdc_dataptr͊Ɉˑf[^|C^ */
	if (!fdc_dataptr) {
		if (!file_word_write(fileh, 0x2000)) {
			return FALSE;
		}
	}
	else {
		if (!file_word_write(fileh, (WORD)(fdc_dataptr - &fdc_buffer[0]))) {
			return FALSE;
		}
	}

	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_dword_write(fileh, fdc_seekofs[i])) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_dword_write(fileh, fdc_secofs[i])) {
			return FALSE;
		}
	}

	/* I/O */
	if (!file_byte_write(fileh, fdc_command)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_status)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_trkreg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_secreg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_datareg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_sidereg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_drvreg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_motor)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_drqirq)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_cmdtype)) {
		return FALSE;
	}

	/* ̑ */
	if (!file_word_write(fileh, fdc_totalcnt)) {
		return FALSE;
	}
	if (!file_word_write(fileh, fdc_nowcnt)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, fdc_seekvct)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_indexcnt)) {
		return FALSE;
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_write(fileh, fdc_access[i])) {
			return FALSE;
		}
	}
	if (!file_bool_write(fileh, TRUE)) {
		return FALSE;
	}

	/* Ver9.05/7.05g */
#ifdef FDDSND
	if (!file_bool_write(fileh, fdc_wait)) {
		return FALSE;
	}
#else
	if (!file_bool_write(fileh, FALSE)) {
		return FALSE;
	}
#endif

#if XM7_VER >= 3
	/* Ver8g */
	if (!file_byte_write(fileh, fdc_2ddmode)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_logidrv)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, fdc_drvregP)) {
		return FALSE;
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_write(fileh, fdc_physdrv[i])) {
			return FALSE;
		}
	}
#endif

	if (!file_bool_write(fileh, TRUE)) {
		return FALSE;
	}
#if XM7_VER >= 2
	if (!file_byte_write(fileh, fdc_dsenable)) {
		return FALSE;
	}
#endif

	return TRUE;
}

/*
 *	FDC
 *	[h
 */
BOOL FASTCALL fdc_load(int fileh, int ver)
{
	int i;
	BYTE ready[FDC_DRIVES];
	char fname[FDC_DRIVES][256 + 1];
	BYTE media[FDC_DRIVES];
	WORD offset;
	BOOL tmp;
	int pathlen;

	/* o[W`FbN */
	if (ver < 200) {
		return FALSE;
	}

	/* t@C̍ő啶 */
#if XM7_VER >= 3
	if (((ver >= 715) && (ver <= 799)) || (ver >= 915)) {
#elif XM7_VER >= 2
	if ((ver >= 715) && (ver <= 799)) {
#else
	if ((ver >= 305) && (ver <= 499)) {
#endif
		pathlen = 256;
	}
	else {
		pathlen = 128;
	}

	/* t@C֌WɎĂ */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_read(fileh, &ready[i])) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_read(fileh, (BYTE*)fname[i], pathlen + 1)) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_read(fileh, &media[i])) {
			return FALSE;
		}
	}

	/* ă}Eg݂ */
	for (i=0; i<FDC_DRIVES; i++) {
		fdc_setdisk(i, NULL);
		if (ready[i] != FDC_TYPE_NOTREADY) {
			fdc_setdisk(i, fname[i]);
			if (fdc_ready[i] != FDC_TYPE_NOTREADY) {
				if (fdc_medias[i] >= (media[i] + 1)) {
					fdc_setmedia(i, media[i]);
				}
			}
		}
	}

	/* Ver4g că`FbNӖȂł(` */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_bool_read(fileh, &fdc_teject[i])) {
			return FALSE;
		}
	}

	/* t@CXe[^X */
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_read(fileh, &fdc_track[i])) {
			return FALSE;
		}
	}
	if (!file_read(fileh, fdc_buffer, 0x2000)) {
		return FALSE;
	}

	/* fdc_dataptr͊Ɉˑf[^|C^ */
	if (!file_word_read(fileh, &offset)) {
		return FALSE;
	}
	if (offset >= 0x2000) {
		fdc_dataptr = NULL;
	}
	else {
		fdc_dataptr = &fdc_buffer[offset];
	}

	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_dword_read(fileh, &fdc_seekofs[i])) {
			return FALSE;
		}
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_dword_read(fileh, &fdc_secofs[i])) {
			return FALSE;
		}
	}

	/* I/O */
	if (!file_byte_read(fileh, &fdc_command)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_status)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_trkreg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_secreg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_datareg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_sidereg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_drvreg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_motor)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_drqirq)) {
		return FALSE;
	}
	if (ver < 600) {
		fdc_drqirq |= (BYTE)0x20;
	}
	if (!file_byte_read(fileh, &fdc_cmdtype)) {
		return FALSE;
	}

	/* ̑ */
	if (!file_word_read(fileh, &fdc_totalcnt)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &fdc_nowcnt)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &fdc_seekvct)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &fdc_indexcnt)) {
		return FALSE;
	}
	for (i=0; i<FDC_DRIVES; i++) {
		if (!file_byte_read(fileh, &fdc_access[i])) {
			return FALSE;
		}
	}
	/* o[WƂ̌݊p(u[gtO) */
	if (!file_bool_read(fileh, &tmp)) {
		return FALSE;
	}

	/* Cxg */
	schedule_handle(EVENT_FDC_M, fdc_multi_event);
	schedule_handle(EVENT_FDC_L, fdc_lost_event);
#ifdef FDDSND
	schedule_handle(EVENT_FDD_SEEK, fdd_seek_event);
#endif
#if XM7_VER >= 3
	if ((ver >= 905) || ((ver >= 705) && (ver <= 799))) {
#elif XM7_VER >= 2
	if (ver >= 705) {
#else
	if (ver >= 300) {
#endif
		/* Ver9.05/7.05g */
#ifdef FDDSND
		if (!file_bool_read(fileh, &fdc_wait)) {
			return FALSE;
		}
		/* FDANZXEFCgLȏꍇ̓CxgnhύX */
		if (fdc_wait) {
			schedule_handle(EVENT_FDC_L, fdc_drq_event);
		}
#else
		if (!file_bool_read(fileh, &tmp)) {
			return FALSE;
		}
#endif
	}
#ifdef FDDSND
	else {
		/* EFCg[hFALSE */
		fdc_wait = FALSE;

		/* V[NCxg(zbgZbgCxg)폜 */
		schedule_delevent(EVENT_FDD_SEEK);
	}
#endif

#if XM7_VER >= 3
	/* Ver8g */
	if (ver < 800) {
		fdc_2ddmode = FALSE;
		fdc_logidrv = 0;
		fdc_drvregP = fdc_drvreg;
		/* _hCuhCuɐݒ */
		for (i=0; i<FDC_DRIVES; i++) {
			fdc_physdrv[i] = (BYTE)i;
		}
	}
	else {
		if (!file_byte_read(fileh, &fdc_2ddmode)) {
			return FALSE;
		}
		if (!file_byte_read(fileh, &fdc_logidrv)) {
			return FALSE;
		}
		if (!file_byte_read(fileh, &fdc_drvregP)) {
			return FALSE;
		}
		for (i=0; i<FDC_DRIVES; i++) {
			if (!file_byte_read(fileh, &fdc_physdrv[i])) {
				return FALSE;
			}
		}
	}
#endif

#if XM7_VER >= 3
	if (((ver >= 720) && (ver <= 799)) || (ver >= 920)) {
#elif XM7_VER >= 2
	if ((ver >= 720) && (ver <= 799)) {
#else
	if ((ver >= 310) && (ver <= 499)) {
#endif
		if (!file_bool_read(fileh, &tmp)) {
			return FALSE;
		}
	}

#if XM7_VER >= 2
#if XM7_VER >= 3
	if (((ver >= 722) && (ver <= 799)) || (ver >= 922)) {
#else
	if ((ver >= 722) && (ver <= 799)) {
#endif
		if (!file_byte_read(fileh, &fdc_dsenable)) {
			return FALSE;
		}
	}
	else {
		fdc_dsenable = 0x00;
	}
#endif

	/* g */
	fdi_init = FALSE;
	fdc_onetime = 32;

	if (fdc_ready[fdc_drvreg] == FDC_TYPE_FDX) {
		fdc_readbuf(fdc_drvreg);
	}

	return TRUE;
}

/*
 *	FDXT|[gR[h
 */

/*
 *	FDX
 *	rbg擾
 */
BYTE FASTCALL fdx_bf_getbit(const BYTE *buf, int length, int offset)
{
	// bv
	if (offset < 0) {
		offset += length;
	}
	if (offset >= length) {
		offset -= length;
	}

	return (buf[offset >> 3] >> (7 - (offset & 7))) & 1;
}

/*
 *	FDX
 *	rbgݒ
 */
void FASTCALL fdx_bf_setbit(BYTE *buf, int length, int offset)
{
	// bv
	if (offset < 0) {
		offset += length;
	}
	if (offset >= length) {
		offset -= length;
	}

	buf[offset >> 3] |= (0x80 >> (offset & 7));
}

/*
 *	FDX
 *	rbgNA
 */
void FASTCALL fdx_bf_clrbit(BYTE *buf, int length, int offset)
{
	// bv
	if (offset < 0) {
		offset += length;
	}
	if (offset >= length) {
		offset -= length;
	}

	buf[offset >> 3] &= ~(0x80 >> (offset & 7));
}

/*
 *	FDX
 *	oCg擾
 */
BYTE FASTCALL fdx_bf_getbyte(const BYTE *buf, int length, int offset)
{
	int i;
	WORD *p;
	WORD data;

	// bv
	if (offset < 0) {
		offset += length;
	}
	if (offset >= length) {
		offset -= length;
	}

	// P擾
	i = offset >> 3;
	if ((offset & 7) == 0 && (offset + 7) < length) {
		return buf[i];
	}

	// 8rbgxɎo邩
	if ((i + 1) < (length >> 3)) {
		p = (WORD *)(buf + i);
		data = *p;
		data = (data << 8) | (data >> 8);
		data >>= (8 - (offset & 7));
	} else {
		data = 0;
		for (i = 0; i < 8; i++) {
			data <<= 1;
			data |= fdx_bf_getbit(buf, length, offset + i);
		}
	}

	// f[^ԋp
	return (BYTE)data;
}

/*
 *	FDX
 *	oCgݒ
 */
void FASTCALL fdx_bf_setbyte(
	BYTE *buf, int length, int offset, BYTE data)
{
	int i;
	int shift;
	WORD mask;
	WORD set;
	WORD *p;
	WORD mix;

	// bv
	if (offset < 0) {
		offset += length;
	}
	if (offset >= length) {
		offset -= length;
	}

	// Pݒ
	i = offset >> 3;
	if ((offset & 7) == 0 && (offset + 7) < length) {
		buf[i] = data;
		return;
	}

	// 8rbgxɍXVł邩
	if ((i + 1) < (length >> 3)) {
		shift = 8 - (offset & 7);
		if (shift == 8) {
			buf[i] = data;
			return;
		}
		shift = 8 - (offset & 7);
		mask = 0xff << shift;
		set = ((WORD)data) << shift;
		p = (WORD *)(buf + i);
		mix = *p;
		mix = (mix << 8) | (mix >> 8);
		mix = (mix & ~mask) | set;
		*p = (mix << 8) | (mix >> 8);
		return;
	}

	// rbgPʂŐݒ
	for (i = 0; i < 8; i++) {
		if (data & 0x80) {
			fdx_bf_setbit(buf, length, offset + i);
		} else {
			fdx_bf_clrbit(buf, length, offset + i);
		}
		data <<= 1;
	}
}


/*
 *	FDX
 *	rbgtB[h擾
 */
void FASTCALL fdx_bf_copybf(BYTE *dst, int dlen, int doff,
	const BYTE *src, int slen, int soff, int len)
{
	int i;
	int j;
	int c;
	BYTE data;

	// oCgPʂŐݒ
	i = soff;
	j = doff;
	c = len >> 3;
	while (c) {
		data = fdx_bf_getbyte(src, slen, i);
		fdx_bf_setbyte(dst, dlen, j, data);
		i += 8;
		j += 8;
		c--;
	}

	// rbgPʂŐݒ
	c = len & 7;
	while (c) {
		if (fdx_bf_getbit(src, slen, i)) {
			fdx_bf_setbit(dst, dlen, j);
		} else {
			fdx_bf_clrbit(dst, dlen, j);
		}
		i++;
		j++;
		c--;
	}
}

/*
 *	FDX
 *	rbgtB[hݒ
 */
void FASTCALL fdx_bf_setbf(BYTE *dst, int dlen, int offset, BYTE *src, int slen)
{
	int i;
	int j;
	int c;
	BYTE data;

	// oCgPʂŐݒ
	i = offset;
	j = 0;
	c = slen >> 3;
	while (c) {
		data = fdx_bf_getbyte(src, slen, j);
		fdx_bf_setbyte(dst, dlen, i, data);
		i += 8;
		j += 8;
		c--;
	}

	// rbgPʂŐݒ
	c = slen & 7;
	while (c) {
		if (fdx_bf_getbit(src, slen, j)) {
			fdx_bf_setbit(dst, dlen, i);
		} else {
			fdx_bf_clrbit(dst, dlen, i);
		}
		i++;
		j++;
		c--;
	}
}

/*
 *	FDX
 *	rbgtB[h()
 */
int FASTCALL fdx_bf_findbf_in(
	const BYTE *buf, int length, int offset, int limit,
	const BYTE *pat, int plen)
{
	int i;
	int j;
	int pos;

	ASSERT(limit > 0);
	ASSERT(pat);
	ASSERT(plen > 0);
	ASSERT(limit >= plen);

	// p^[팸
	limit -= (plen - 1);

	if (plen & 7) {
		// rbgPʔr
		for (i = 0; i < limit; i++) {
			pos = offset + i;

			for (j = 0; j < plen; j++) {
				if (fdx_bf_getbit(buf, length, pos + j) !=
					fdx_bf_getbit(pat, plen, j)) {
					break;
				}
			}

			if (j >= plen) {
				return i;
			}
		}
	} else {
		// oCgPʔr
		for (i = 0; i < limit; i++) {
			pos = offset + i;

			for (j = 0; j < plen; j+=8) {
				if (fdx_bf_getbyte(buf, length, pos + j) !=
					fdx_bf_getbyte(pat, plen, j)) {
					break;
				}
			}

			if (j >= plen) {
				return i;
			}
		}
	}

	return -1;
}

/*
 *	FDX
 *	rbgtB[h
 */
int FASTCALL fdx_bf_findbf(
	const BYTE *buf, int length, int offset, int limit,
	const BYTE *pat, int plen)
{
	// 4oCgPʂłȂΒʏ̃rbgtB[hT
	if (plen & 31) {
		return fdx_bf_findbf_in(buf, length, offset, limit, pat, plen);
	}

	// T~bg
	int pos = offset;
	limit += offset;
	limit -= plen;

	// łȂ
	if (pos > limit) {
		return -1;
	}

	// [N쐬
	int num = plen / 32;
	DWORD *pat4 = (DWORD*)malloc(num * sizeof(DWORD));
	DWORD *comp = (DWORD*)malloc((num + 1) * sizeof(DWORD));

	// p^[
	for (int i = 0; i < num; i++) {
		pat4[i] = pat[i * 4 + 0];
		pat4[i] <<= 8;
		pat4[i] |= pat[i * 4 + 1];
		pat4[i] <<= 8;
		pat4[i] |= pat[i * 4 + 2];
		pat4[i] <<= 8;
		pat4[i] |= pat[i * 4 + 3];
	}

	// [U
	for (int i = 0; i < num; i++) {
		comp[i] = fdx_bf_getbyte(buf, length, pos + i * 32 + 0);
		comp[i] <<= 8;
		comp[i] |= fdx_bf_getbyte(buf, length, pos + i * 32 + 8);
		comp[i] <<= 8;
		comp[i] |= fdx_bf_getbyte(buf, length, pos + i * 32 + 16);
		comp[i] <<= 8;
		comp[i] |= fdx_bf_getbyte(buf, length, pos + i * 32 + 24);
	}

	do {
		// 㑱4oCg
		comp[num] = fdx_bf_getbyte(buf, length, pos + num * 32 + 0);
		comp[num] <<= 8;
		comp[num] |= fdx_bf_getbyte(buf, length, pos + num * 32 + 8);
		comp[num] <<= 8;
		comp[num] |= fdx_bf_getbyte(buf, length, pos + num * 32 + 16);
		comp[num] <<= 8;
		comp[num] |= fdx_bf_getbyte(buf, length, pos + num * 32 + 24);

		// VtgȂ32rbgr
		for (int i = 0; i < 32; i++) {
			int j;
			for (j = 0; j < num; j++) {
				if (comp[j] != pat4[j]) {
					break;
				}
			}

			// SĈv
			if (j == num) {
				free(pat4);
				free(comp);
				if (pos > limit) {
					return -1;
				} else {
					return pos + i - offset;
				}
			}

			// Vtg
			for (j = 0; j < num; j++) {
				comp[j] <<= 1;
				comp[j] |= (comp[j + 1] >> 31) & 1;
			}
			comp[num] <<= 1;
		}

		// 
		pos += 32;
	} while (pos <= limit);

	// [N
	free(pat4);
	free(comp);

	return -1;
}

/*
 *	FDX
 *	NbN(AtH[}bg̉ӏ͕sf[^ɒu)
 */
int FASTCALL fdx_bf_splitclock(
	BYTE *buf, int length, int offset,
	BYTE *dbuf, int dlen, BOOL instab)
{
	int i;
	int j;
	int total;
	int count;
	int zeros;
	BYTE bit;
	BYTE temp[4];
	BYTE data;
	DWORD rand;

	// NbN̂
	total = 0;

	if (!instab) {
		for (i = 0; i < dlen; i++) {
			data = 0;
			fdx_bf_copybf(temp, 16, 0, buf, length, offset, 16);
			for (j = 0; j < 2; j++) {
				data = (data << 1) | ((temp[j] >> 6) & 0x01);
				data = (data << 1) | ((temp[j] >> 4) & 0x01);
				data = (data << 1) | ((temp[j] >> 2) & 0x01);
				data = (data << 1) | ((temp[j] >> 0) & 0x01);
			}
			offset += 16;
			total += 16;
			*dbuf++ = data;
		}

		return total;
	}

	// sf[^Č
	count = 0;
	zeros = 0;

	for (i = 0; i < dlen; i++) {
		data = 0;
		rand = rand_xor();
		for (j = 0; j < 16; j++) {
			bit = fdx_bf_getbit(buf, length, offset);
			if (j & 1) {
				data <<= 1;
				data |= bit;
			}

			if (bit) {
				count = 0;
				zeros = 0;
			} else {
				count++;
				zeros++;
			}

			// _mCY
			if (count >= 4 && (rand & 1)) {
				data |= 1;
				count = 0;
			}

			// s̈̃rbg
			if (zeros >= 4 && ((zeros - 4) & 0x7f) == 0) {
				offset += rand_xor() & 3;
			}

			offset++;
			total++;
			rand >>= 1;
		}
		*dbuf++ = data;
	}

	return total;
}

/*
 *	FDX
 *	GR[hf[^->RAWf[^
 */
int FASTCALL fdx_encode_to_raw(
	int rate, BYTE *enc, int enclen, BYTE *raw, int rawlen)
{
	int i;
	BYTE pulse;

	// ϊNA
	memset(raw, 0x00, (rawlen + 7) >> 3);

	// pXf[^
	if (rate == 8000 || rate == 1000) {
		pulse = 0xf0;
	} else {
		pulse = 0xc0;
	}

	// ϊ
	for (i = 0; i < enclen; i++) {
		if (fdx_bf_getbit(enc, enclen, i)) {
			fdx_bf_setbyte(raw, rawlen, i << 3, pulse);
		}
	}

	// f[^Ԃ
	return enclen << 3;
}

/*
 *	FDX
 *	pXv
 */
int FASTCALL fdx_measure_pulse(int diff)
{
	static int prev = 0;

	int width;
	if ((prev + diff) >= 48) {
		width = (diff + 3) >> 3;
	} else {
		width = (diff + 4) >> 3;
	}

	prev = diff;
	return width;
}

/*
 *	FDX
 *	RAWf[^->GR[hf[^
 */
int FASTCALL fdx_raw_to_encode(BYTE *raw, int rawlen, BYTE *enc, int enclen)
{
	int i;
	int offset;
	BYTE data;
	BYTE prev;
	BYTE edge;
	int cur;
	int diff;
	int width;
	int epos;

	// GR[hf[^ɃNA
	memset(enc, 0x00, (enclen + 7) >> 3);

	// ̗オGbWT
	data = fdx_bf_getbit(raw, rawlen, rawlen - 1);
	for (offset = 0; offset < rawlen; offset++) {
		data <<= 1;
		data |= fdx_bf_getbit(raw, rawlen, offset);

		// オGbW
		if ((data & 3) == 1) {
			break;
		}
	}

	// AtH[}bg̏ꍇ𒆎~
	if (offset >= rawlen) {
		return rawlen >> 3;
	}

	// ϊpJE^ޏ
	prev = 0;
	data = 0;
	cur = 0;
	epos = offset >> 3;
	diff = 0;

	// pXݒ
	fdx_bf_setbit(enc, enclen, epos);

	// ϊ
	while (cur < rawlen) {
		// f[^擾
		data = fdx_bf_getbyte(raw, rawlen, cur + offset);

		// GbWZo
		edge = (((prev << 7) | (data >> 1)) ^ data) & data;
		prev = data;

		// GbW΃XLbv
		if (!edge) {
			diff += 8;
			cur += 8;
			continue;
		}

		// rbg
		for (i = 0; i < 8; i++) {
			// オ茟
			if (edge & 0x80) {
				// ŏԊuȃpX𖳎
				if (diff >= 14) {
					// pXԊuZo
					width = fdx_measure_pulse(diff);
					epos += width;

					// pXݒ
					fdx_bf_setbit(enc, enclen, epos);

					// JE^NA
					diff = 0;
				}
			}
			
			// JE^Z
			diff++;
			cur++;

			// ݈ʒu`FbN
			if (cur >= rawlen) {
				break;
			}

			// ̃GbW
			edge <<= 1;

			// c̃GbW
			if (edge == 0) {
				diff += 7 - i;
				cur += 7 - i;
				break;
			}
		}
	}

	// I[o[
	if (cur > rawlen) {
		diff -= (cur - rawlen);
	}

	// L^ꂽf[^Ԃ
	enclen = epos - (offset >> 3) + fdx_measure_pulse(diff);

	// f[^؂l߂ꂽɍŌ̃pXĐݒ肷
	if (epos >= enclen) {
		fdx_bf_setbit(enc, enclen, epos);
	}

	return enclen;
}

/*
 *	FDX
 *	RAWf[^̃GR[hf[^ʒuT
 */
int FASTCALL fdx_encode_to_raw_pos(BYTE *raw, int rawlen, int encpos)
{
	int i;
	int offset;
	BYTE data;
	BYTE prev;
	BYTE edge;
	int cur;
	int diff;
	int epos;
	int width;

	// ̗オGbWT
	data = fdx_bf_getbit(raw, rawlen, rawlen - 1);
	for (offset = 0; offset < rawlen; offset++) {
		data <<= 1;
		data |= fdx_bf_getbit(raw, rawlen, offset);

		// オGbW
		if ((data & 3) == 1) {
			break;
		}
	}

	// AtH[}bg̏ꍇ𒆎~
	if (offset >= rawlen) {
		return encpos << 3;
	}

	// ϊpJE^ޏ
	diff = 0;
	prev = 0;
	data = 0;
	cur = 0;
	epos = offset >> 3;
	diff = 0;

	// ϊ
	while (cur < rawlen) {
		// f[^擾
		data = fdx_bf_getbyte(raw, rawlen, cur + offset);

		// GbWZo
		edge = (((prev << 7) | (data >> 1)) ^ data) & data;
		prev = data;

		// GbW΃XLbv
		if (!edge) {
			diff += 8;
			cur += 8;
			continue;
		}

		// rbg
		for (i = 0; i < 8; i++) {
			// オ茟
			if (edge & 0x80) {
				// ŏԊuȃpX𖳎
				if (diff >= 14) {
					// pXԊuZo
					width = fdx_measure_pulse(diff);
					epos += width;

					// RAWf[^̈ʒuL^
					if (epos >= encpos) {
						return cur + offset - ((epos - encpos) << 3);
					}

					// JE^NA
					diff = 0;
				}
			}
			
			// JE^Z
			diff++;
			cur++;

			// ݈ʒu`FbN
			if (cur >= rawlen) {
				break;
			}

			// ̃GbW
			edge <<= 1;

			// c̃GbW
			if (edge == 0) {
				diff += 7 - i;
				cur += 7 - i;
				break;
			}
		}
	}

	return cur;
}

/*
 *	FDX
 *	READ TRACKf[^
 */
int FASTCALL fdx_make_track(BYTE *buf, int length, BYTE *dbuf)
{
	static const BYTE SYNC[6] = {
		0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA	// $00$00$00
	};

	static const BYTE AM_INDEX[6] = {
		0x52, 0x24, 0x52, 0x24, 0x52, 0x24	// $C2$C2$C2
	};

	static const BYTE AM_OTHER[6] = {
		0x44, 0x89, 0x44, 0x89, 0x44, 0x89	// $A1$A1$A1
	};

	/*  */
	int total = 0;
	int offset = rand_xor() & 15;
	int stable = offset;
	int zeros = 0;

	while (offset < length) {
		BYTE data = 0;
		DWORD rand = rand_xor();
		for (int i = 0; i < 16; i++) {
			/* SYNC܂̓AhX}[N𔭌NbNZbg */
			if (i > 0) {
				BYTE mark[6];
				fdx_bf_copybf(mark, 6 * 8, 0, buf, length, offset, 6 * 8);
				if (memcmp(mark, SYNC, 6) == 0) {
					stable = offset + 64;
				} else if (memcmp(mark, AM_INDEX, 6) == 0 ||
					memcmp(mark, AM_OTHER, 6) == 0) {
					data <<= (16 - i) / 2;
					stable = offset + 1024;
					zeros = 0;
					break;
				}
			}

			/* NbN */
			BYTE bit = fdx_bf_getbit(buf, length, offset);
			if (i & 1) {
				data <<= 1;
				data |= bit;
			}

			/* A0̐L^ */
			if (bit) {
				zeros = 0;
			} else {
				zeros++;
			}

			/* sf[^Č */
			if (zeros >= 4 && (rand & 1)) {
				data |= 1;
				zeros = 0;
			}

			offset++;
			rand >>= 1;

			/* 1璼Ɏ~߂ */
			if (offset >= length) {
				break;
			}
		}

		// orbg𔭐
		if (offset > stable) {
			if ((rand_xor() & 0xff) < 64) {
				offset++;
			}
		}

		*dbuf++ = data;
		total++;
	}

	/* f[^Ԃ */
	return total;
}

/*
 *	FDX
 *	gbNf[^()
 */
fdxtrkstat_t* FASTCALL fdx_analyze_track_in(
	fdxtrkstat_t *stat, BYTE *enc, int enclen, int idams[], BOOL needdata)
{
	int i;
	int num;
	int pos;
	DWORD err;
	int offset;
	int siz;
	BYTE buf[0x4000 + 6];
	BYTE *p;
	DWORD chrn[4];
	WORD crc;
	int limit;
	int dam;
	int ddam;
	int gap;
	int maxeos;
	int maxsec;
	fdxsecstat_t *sector;

	// IAMT
	pos = fdx_bf_findbf(enc, enclen, 0, enclen, FDX_IAM_MFM, 12 * 8);
	if (pos >= 0) {
		stat->status |= FDX_INF_IAM;
		stat->iamoffset = pos + 4 * 8;
	}

	// SZN^[
	for (i = 0, num = 0; num < FDX_MAX_SECTOR; i++) {
		// G[R[h
		err = FDX_FDD_NOERROR;

		// ItZbgݒ
		offset = idams[i];
		if (offset < 0) {
			break;
		}

		// NbNăf[^fR[h
		p = buf;
		offset += fdx_bf_splitclock(enc, enclen, offset, p, 10, FALSE);

		// ID CRC`FbN
		crc = calc_crc(p, 8);

		if ((BYTE)(crc >> 8) != buf[8] ||
			(BYTE)crc != buf[9]) {
			err |= (FDX_FDD_DATAERR | FDX_FDD_IDCRC);
		}

		// CHRNƃZN^Zo
		chrn[0] = buf[4];
		chrn[1] = buf[5];
		chrn[2] = buf[6];
		chrn[3] = buf[7];
		siz = 128 << (buf[7] & 3);

		// ZN^`FbN
		if (buf[7] > 3) {
			stat->status |= FDX_ERR_IINV;
		} 

		// DAM/DDAM͎̌IDAM܂
		if (idams[i + 1]>= 0){
			limit = idams[i + 1] - offset;
		} else {
			limit = enclen - offset;
		}

		// DAMT
		dam = fdx_bf_findbf(
			enc, enclen, offset, limit, FDX_DAM_MFM, 12 * 8);

		// SYNCp^[
		if (dam >= 0) {
			dam += 4 * 8;
		}

		// DDAMT
		ddam = fdx_bf_findbf(
			enc, enclen, offset, limit, FDX_DDAM_MFM, 12 * 8);

		// SYNCp^[
		if (ddam >= 0) {
			ddam += 4 * 8;
		}

		// DAM/DDAMTʕ]
		if (dam < 0 && ddam < 0) {
			// DAM/DDAMȂ
			err |= FDX_FDD_MDAM;
			pos = -1;
		} else if (dam >= 0 && ddam < 0) {
			// DAM
			pos = dam;
		} else if (dam < 0 && ddam >= 0) {
			// DDAM
			err |= FDX_FDD_DDAM;
			pos = ddam;
		} else {
			// 
			if (dam < ddam) {
				// DAM
				pos = dam;
			} else {
				// DDAM
				err |= FDX_FDD_DDAM;
				pos = ddam;
			}
		}

		// DAM/DDAMGAP2̃TCY
		gap = 0;
		if (pos >= 0) {
			gap = pos - 12 * 16;
			gap /= 16;
		}

		// MFM/FM̃ZN^݂
		stat->status |= FDX_INF_MFM;

		// ZN^쐬
		sector = &stat->sector[num++];
		sector->idamoffset = idams[i];
		sector->chrn[0] = chrn[0];
		sector->chrn[1] = chrn[1];
		sector->chrn[2] = chrn[2];
		sector->chrn[3] = chrn[3];
		sector->gap2 = gap;
		sector->size = siz;
		sector->icrc[0] = buf[8];
		sector->icrc[1] = buf[9];
		sector->enclen = siz * 16;
		if (needdata) {
			sector->data = malloc(siz);
			sector->encdata = malloc(siz * 16 >> 3);
		}

		// ID̃G[X^[^Xɔf
		if (err & FDX_FDD_IDCRC) {
			stat->status |= FDX_ERR_ICRC;
			stat->status |= FDX_ERR_IINV;
		}

		// DAM/DDAMȂ̂ňȉXLbv
		if (err & FDX_FDD_MDAM) {
			stat->status |= FDX_ERR_DINV;
			sector->err = err;
			continue;
		}

		// DAM/DDAM̈ʒu␳
		offset += pos;
		sector->damoffset = offset;

		// NbNăf[^fR[h

		// DAM/DDAM(4oCg)CRC(2oCg)܂
		offset += fdx_bf_splitclock(enc, enclen, offset, p, siz + 6, FALSE);

		// ZN^ItZbg
		sector->eosoffset = offset;

		// DATA CRC`FbN
		crc = calc_crc(p, siz + 4);

		if ((BYTE)(crc >> 8) != buf[siz + 4] ||
			(BYTE)crc != buf[siz + 5]) {
			stat->status |= FDX_ERR_DCRC;
			err |= (FDX_FDD_DATAERR | FDX_FDD_DATACRC);
		}
		sector->dcrc[0] = buf[siz + 4];
		sector->dcrc[1] = buf[siz + 5];

		// ZN^Ƀf[^]
		sector->err = err;
		if (needdata) {
			memcpy(sector->data, &buf[4], siz);
		}

		// GR[hf[^ݒ
		if (needdata) {
			offset = sector->damoffset;
			offset += 4 * 16;
			fdx_bf_copybf(sector->encdata, sector->enclen, 0,
				enc, enclen, offset, sector->enclen);
		}
	}

	// ZN^m
	stat->num = num;

	// Xe[^XɂZN^ݒ
	stat->status |= (stat->num & FDX_INF_SECMSK);

	// GAP3̎Zo
	for (i = 0; i < stat->num; i++) {
		sector = &stat->sector[i];
		offset = sector->eosoffset;

		gap = 0;
		if (i == stat->num - 1) {
			// ŏI͑Sf[^܂
			if (offset < enclen) {
				gap = (enclen - offset) / 16;
			}
		} else {
			// r͎IDAM̈ʒu܂
			if (offset < stat->sector[i + 1].idamoffset) {
				gap = stat->sector[i + 1].idamoffset - offset - 6;
				gap /= 16;
				if (gap < 0) {
					gap = 0;
				}
			}
		}
		sector->gap3 = gap;
	}

	// GAP1̃TCYZo
	if (stat->status & FDX_INF_IAM) {
		for (i = 0; i < stat->num; i++) {
			sector = &stat->sector[i];
			if (sector->idamoffset > stat->iamoffset) {
				stat->gap1 = sector->idamoffset;
				stat->gap1 -= 12 * 16;
				stat->gap1 -= stat->iamoffset;
				stat->gap1 -= 4 * 16;
				stat->gap1 /= 16;
				break;
			}
		}
	}

	// GAP4b̃TCYZo(I[łɂZN^̌)
	maxeos = -1;
	maxsec = -1;
	for (i = 0; i < stat->num; i++) {
		sector = &stat->sector[i];
		if (sector->eosoffset > maxeos) {
			maxeos = sector->eosoffset;
			maxsec = i;
		}
	}

	if (maxsec >= 0) {
		if (enclen > maxeos) {
			stat->gap4b = (enclen - maxeos) / 16;
		} else {
			stat->gap4b = 0;
		}
		stat->sector[maxsec].gap3 = 0;
	}

	// GAP4ãTCY
	if (stat->status & FDX_INF_IAM) {
		stat->gap4a = (stat->iamoffset - 12 * 16) / 16;
	} else {
		stat->gap4a = (stat->sector[0].idamoffset - 12 * 16) / 16;
	}
	if (stat->num > 0) {
		sector = &stat->sector[stat->num - 1];
		if (sector->idamoffset > sector->eosoffset) {
			stat->gap4a -= sector->eosoffset / 16;
		}
	}
	if (stat->gap4a < 0) {
		stat->gap4a = 0;
	}

	// bv
	for (i = 0; i < stat->num; i++) {
		sector = &stat->sector[i];
		if (sector->idamoffset >= enclen) {
			sector->idamoffset -= enclen;
		}
		if (sector->damoffset >= enclen) {
			sector->damoffset -= enclen;
		}
		if (sector->eosoffset >= enclen) {
			sector->eosoffset -= enclen;
		}
	}

	// CfbNXz[ׂ̃ZN^݂邩
	for (i = 0; i < stat->num; i++) {
		sector = &stat->sector[i];
		if (sector->idamoffset > sector->eosoffset) {
			stat->status |= FDX_INF_ISTR;
			break;
		}
	}

	return stat;
}

/*
 *	FDX
 *	gbNf[^
 */
fdxtrkstat_t* FASTCALL fdx_analyze_track(
	BYTE *buf, int buflen, BOOL israw, BOOL needdata)
{
	int i;
	BYTE *enc;
	int enclen;
	fdxtrkstat_t *stat;
	int pos;
	int m;
	int idams[FDX_MAX_SECTOR];
	fdxsecstat_t *sec;
	int logical;
	int start;
	int end;
	int elapse;
	int ratio;

	// 
	stat = malloc(sizeof(fdxtrkstat_t));
	memset(stat, 0x00, sizeof(fdxtrkstat_t));
	memset(idams, 0xff, sizeof(idams));

	// GR[hf[^
	enc = malloc(FDX_ENC_BYTES);
	enclen = FDX_ENC_BITS;
	if (israw) {
		// RAWf[^ȂGR[hf[^ɕϊ
		enclen = fdx_raw_to_encode(buf, buflen, enc, enclen);
	} else {
		// GR[hf[^ȂRs[
		memcpy(enc, buf, (buflen + 7) >> 3);
		enclen = buflen;
	}

	// GR[hf[^ݒ
	stat->encbuf = enc;
	stat->enclen = enclen;

	// IDAMT(MFM)
	m = 0;
	for (i = 0; i <= enclen;) {
		// p^[T
		pos = fdx_bf_findbf(enc, enclen, i, enclen - i, FDX_IDAM_MFM, 12 * 8);
		if (pos < 0) {
			break;
		}

		// IDAM($A1,$A1,$A1,$FE)̈ʒuL^
		if (m < FDX_MAX_SECTOR) {
			idams[m++] = i + pos + 4 * 8;
		}

		// TJnʒuXV
		i += pos + 12 * 8;
	}

	// AtH[}bgf[^
	if (m == 0) {
		stat->status = FDX_ERR_UNKN;
		return stat;
	}

	// ZN^
	if (stat->status != FDX_ERR_UNKN) {
		fdx_analyze_track_in(stat, enc, enclen, idams, needdata);
	}

	// GR[h͂܂
	if (!israw) {
		return stat;
	}

	// f[^]Ԕ̐ݒ
	if (stat->num > 0) {
		for (i = 0; i < stat->num; i++) {
			// f[^ĂZN^Ώ
			sec = &stat->sector[i];
			if (sec->err & FDX_FDD_MDAM) {
				continue;
			}

			// _]
			logical = sec->size * FDX_CELL_BITS;
			logical += FDX_CELL_BITS * (12 + 4 + 2);

			// ]
			elapse = 0;
			start = fdx_encode_to_raw_pos(
				buf, buflen, sec->damoffset - FDX_CELL_BITS * 12);
			end = fdx_encode_to_raw_pos(buf, buflen, sec->eosoffset);
			if (start >= 0 && end >= 0) {
				elapse = end - start;
				if (elapse < 0) {
					elapse += buflen;
				}
				elapse >>= 3;
			}
			if (elapse == 0) {
				elapse = logical;
			}

			// f[^]Ԕ
			// ratio(-100...+100) -> 900(90%) ... 1100(110%) 
			ratio = elapse * 1000;
			ratio /= logical;
			ratio -= 1000;
			if (ratio < -100) {
				ratio = -100;
			} else if (ratio > 100) {
				ratio = 100;
			}
			if (ratio) {
				sec->encratio = ratio;
			}
		}
	}

	return stat;
}

/*
 *	FDX
 *	gbNf[^͉̓[N
 */
void FASTCALL fdx_release_analyzeobject(fdxtrkstat_t *stat)
{
	int i;
	fdxsecstat_t *secstat;

	if (stat->encbuf) {
		free(stat->encbuf);
	}

	for (i = 0; i < stat->num; i++) {
		secstat = &stat->sector[i];
		if (secstat->data) {
			free(secstat->data);
		}
		if (secstat->encdata) {
			free(secstat->encdata);
		}
	}

	free(stat);
}

/*
 *	FDX
 *	MFMZoe[u
 */
static const WORD fdx_mfm_table[256]=
{
	0xAAAA, 0xAAA9, 0xAAA4, 0xAAA5, 0xAA92, 0xAA91, 0xAA94, 0xAA95,
	0xAA4A, 0xAA49, 0xAA44, 0xAA45, 0xAA52, 0xAA51, 0xAA54, 0xAA55,
	0xA92A, 0xA929, 0xA924, 0xA925, 0xA912, 0xA911, 0xA914, 0xA915,
	0xA94A, 0xA949, 0xA944, 0xA945, 0xA952, 0xA951, 0xA954, 0xA955,
	0xA4AA, 0xA4A9, 0xA4A4, 0xA4A5, 0xA492, 0xA491, 0xA494, 0xA495,
	0xA44A, 0xA449, 0xA444, 0xA445, 0xA452, 0xA451, 0xA454, 0xA455,
	0xA52A, 0xA529, 0xA524, 0xA525, 0xA512, 0xA511, 0xA514, 0xA515,
	0xA54A, 0xA549, 0xA544, 0xA545, 0xA552, 0xA551, 0xA554, 0xA555,
	0x92AA, 0x92A9, 0x92A4, 0x92A5, 0x9292, 0x9291, 0x9294, 0x9295,
	0x924A, 0x9249, 0x9244, 0x9245, 0x9252, 0x9251, 0x9254, 0x9255,
	0x912A, 0x9129, 0x9124, 0x9125, 0x9112, 0x9111, 0x9114, 0x9115,
	0x914A, 0x9149, 0x9144, 0x9145, 0x9152, 0x9151, 0x9154, 0x9155,
	0x94AA, 0x94A9, 0x94A4, 0x94A5, 0x9492, 0x9491, 0x9494, 0x9495,
	0x944A, 0x9449, 0x9444, 0x9445, 0x9452, 0x9451, 0x9454, 0x9455,
	0x952A, 0x9529, 0x9524, 0x9525, 0x9512, 0x9511, 0x9514, 0x9515,
	0x954A, 0x9549, 0x9544, 0x9545, 0x9552, 0x9551, 0x9554, 0x9555,
	0x4AAA, 0x4AA9, 0x4AA4, 0x4AA5, 0x4A92, 0x4A91, 0x4A94, 0x4A95,
	0x4A4A, 0x4A49, 0x4A44, 0x4A45, 0x4A52, 0x4A51, 0x4A54, 0x4A55,
	0x492A, 0x4929, 0x4924, 0x4925, 0x4912, 0x4911, 0x4914, 0x4915,
	0x494A, 0x4949, 0x4944, 0x4945, 0x4952, 0x4951, 0x4954, 0x4955,
	0x44AA, 0x44A9, 0x44A4, 0x44A5, 0x4492, 0x4491, 0x4494, 0x4495,
	0x444A, 0x4449, 0x4444, 0x4445, 0x4452, 0x4451, 0x4454, 0x4455,
	0x452A, 0x4529, 0x4524, 0x4525, 0x4512, 0x4511, 0x4514, 0x4515,
	0x454A, 0x4549, 0x4544, 0x4545, 0x4552, 0x4551, 0x4554, 0x4555,
	0x52AA, 0x52A9, 0x52A4, 0x52A5, 0x5292, 0x5291, 0x5294, 0x5295,
	0x524A, 0x5249, 0x5244, 0x5245, 0x5252, 0x5251, 0x5254, 0x5255,
	0x512A, 0x5129, 0x5124, 0x5125, 0x5112, 0x5111, 0x5114, 0x5115,
	0x514A, 0x5149, 0x5144, 0x5145, 0x5152, 0x5151, 0x5154, 0x5155,
	0x54AA, 0x54A9, 0x54A4, 0x54A5, 0x5492, 0x5491, 0x5494, 0x5495,
	0x544A, 0x5449, 0x5444, 0x5445, 0x5452, 0x5451, 0x5454, 0x5455,
	0x552A, 0x5529, 0x5524, 0x5525, 0x5512, 0x5511, 0x5514, 0x5515,
	0x554A, 0x5549, 0x5544, 0x5545, 0x5552, 0x5551, 0x5554, 0x5555
};

/*
 *	FDX
 *	f[^tB
 */
int FASTCALL fdx_fill_mfm(BYTE *dst, BYTE data, int size, BOOL *last)
{
	int i;
	WORD ret;

	for (i = 0; i < size; i++) {
		ret = fdx_mfm_table[data];
		if (*last) {
			ret &= ~0x8000;
		}
		*last = ret & 1 ? TRUE : FALSE;
		*dst++ = (BYTE)(ret >> 8);
		*dst++ = (BYTE)ret;
	}

	return size * 2;
}

/*
 *	FDX
 *	f[^
 */
int FASTCALL fdx_gen_mfm(BYTE *dst, BYTE *src, int size, BOOL *last)
{
	int i;
	WORD ret;

	for (i = 0; i < size; i++) {
		ret = fdx_mfm_table[*src];
		src++;
		if (*last) {
			ret &= ~0x8000;
		}
		*last = ret & 1 ? TRUE : FALSE;
		*dst++ = (BYTE)(ret >> 8);
		*dst++ = (BYTE)ret;
	}

	return size * 2;
}

/*
 *	FDX
 *	IAM
 */
int FASTCALL fdx_gen_iam(BYTE *buf)
{
	// GR[fBOς
	*buf++ = 0x52;
	*buf++ = 0x24;
	*buf++ = 0x52;
	*buf++ = 0x24;
	*buf++ = 0x52;
	*buf++ = 0x24;
	*buf++ = 0x55;
	*buf++ = 0x52;

	return 8;
}

/*
 *	FDX
 *	IDAM
 */
int FASTCALL fdx_gen_idam(BYTE *buf)
{
	// GR[fBOς
	*buf++ = 0x44;
	*buf++ = 0x89;
	*buf++ = 0x44;
	*buf++ = 0x89;
	*buf++ = 0x44;
	*buf++ = 0x89;
	*buf++ = 0x55;
	*buf++ = 0x54;

	return 8;
}

/*
 *	FDX
 *	DAM/DDAM
 */
int FASTCALL fdx_gen_dam(BYTE *buf, BOOL del)
{
	// GR[fBOς
	*buf++ = 0x44;
	*buf++ = 0x89;
	*buf++ = 0x44;
	*buf++ = 0x89;
	*buf++ = 0x44;
	*buf++ = 0x89;
	if (del) {
		*buf++ = 0x55;
		*buf++ = 0x4A;
	} else {
		*buf++ = 0x55;
		*buf++ = 0x45;
	}

	return 8;
}
